config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then
    # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

preserve_perms() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  if [ -e $OLD ]; then
    cp -a $OLD ${NEW}.incoming
    cat $NEW > ${NEW}.incoming
    mv ${NEW}.incoming $NEW
  fi
  config $NEW
}

# Signal the startup script to do some post install configuration
touch etc/webmin/FIRSTRUN
preserve_perms etc/rc.d/rc.webmin.new 
preserve_perms etc/webmin/acl/config.new 
preserve_perms etc/webmin/adsl-client/config.new 
preserve_perms etc/webmin/apache/config.new 
preserve_perms etc/webmin/at/config.new 
preserve_perms etc/webmin/backup-config/config.new 
preserve_perms etc/webmin/bacula-backup/config.new 
preserve_perms etc/webmin/bandwidth/config.new 
preserve_perms etc/webmin/bind8/config.new 
preserve_perms etc/webmin/bootscript-name.new 
preserve_perms etc/webmin/bsdexports/config.new 
preserve_perms etc/webmin/bsdfdisk/config.new 
preserve_perms etc/webmin/change-user/config.new 
preserve_perms etc/webmin/cluster-copy/config.new 
preserve_perms etc/webmin/cluster-cron/config.new 
preserve_perms etc/webmin/cluster-passwd/config.new 
preserve_perms etc/webmin/cluster-shell/config.new 
preserve_perms etc/webmin/cluster-software/config.new 
preserve_perms etc/webmin/cluster-useradmin/config.new 
preserve_perms etc/webmin/cluster-usermin/config.new 
preserve_perms etc/webmin/cluster-webmin/config.new 
preserve_perms etc/webmin/config.new 
preserve_perms etc/webmin/cpan/config.new 
preserve_perms etc/webmin/cron/config.new 
preserve_perms etc/webmin/custom/config.new 
preserve_perms etc/webmin/dfsadmin/config.new 
preserve_perms etc/webmin/dhcpd/config.new 
preserve_perms etc/webmin/dovecot/config.new 
preserve_perms etc/webmin/exim/config.new 
preserve_perms etc/webmin/exports/config.new 
preserve_perms etc/webmin/fail2ban/config.new 
preserve_perms etc/webmin/fdisk/config.new 
preserve_perms etc/webmin/fetchmail/config.new 
preserve_perms etc/webmin/filemin/config.new 
preserve_perms etc/webmin/filter/config.new 
preserve_perms etc/webmin/firewall/config.new 
preserve_perms etc/webmin/firewall6/config.new 
preserve_perms etc/webmin/firewalld/config.new 
preserve_perms etc/webmin/format/config.new 
preserve_perms etc/webmin/fsdump/config.new 
preserve_perms etc/webmin/heartbeat/config.new 
preserve_perms etc/webmin/hpuxexports/config.new 
preserve_perms etc/webmin/htaccess-htpasswd/config.new 
preserve_perms etc/webmin/idmapd/config.new 
preserve_perms etc/webmin/inetd/config.new 
preserve_perms etc/webmin/init/config.new 
preserve_perms etc/webmin/inittab/config.new 
preserve_perms etc/webmin/ipfilter/config.new 
preserve_perms etc/webmin/ipfw/config.new 
preserve_perms etc/webmin/ipsec/config.new 
preserve_perms etc/webmin/iscsi-client/config.new 
preserve_perms etc/webmin/iscsi-server/config.new 
preserve_perms etc/webmin/iscsi-target/config.new 
preserve_perms etc/webmin/iscsi-tgtd/config.new 
preserve_perms etc/webmin/krb5/config.new 
preserve_perms etc/webmin/ldap-client/config.new 
preserve_perms etc/webmin/ldap-server/config.new 
preserve_perms etc/webmin/ldap-useradmin/config.new 
preserve_perms etc/webmin/logrotate/config.new 
preserve_perms etc/webmin/logviewer/config.new 
preserve_perms etc/webmin/lpadmin/config.new 
preserve_perms etc/webmin/lvm/config.new 
preserve_perms etc/webmin/mailboxes/config.new 
preserve_perms etc/webmin/mailcap/config.new 
preserve_perms etc/webmin/man/config.new 
preserve_perms etc/webmin/miniserv.conf.new 
preserve_perms etc/webmin/miniserv.pem.new 
preserve_perms etc/webmin/miniserv.users.new 
preserve_perms etc/webmin/mount/config.new 
preserve_perms etc/webmin/mysql/config.new 
preserve_perms etc/webmin/net/config.new 
preserve_perms etc/webmin/nis/config.new 
preserve_perms etc/webmin/openslp/config.new 
preserve_perms etc/webmin/package-updates/config.new 
preserve_perms etc/webmin/pam/config.new 
preserve_perms etc/webmin/pap/config.new 
preserve_perms etc/webmin/passwd/config.new 
preserve_perms etc/webmin/perl-path.new 
preserve_perms etc/webmin/phpini/config.new 
preserve_perms etc/webmin/postfix/config.new 
preserve_perms etc/webmin/postgresql/config.new 
preserve_perms etc/webmin/ppp-client/config.new 
preserve_perms etc/webmin/pptp-client/config.new 
preserve_perms etc/webmin/pptp-server/config.new 
preserve_perms etc/webmin/proc/config.new 
preserve_perms etc/webmin/procmail/config.new 
preserve_perms etc/webmin/proftpd/config.new 
preserve_perms etc/webmin/qmailadmin/config.new 
preserve_perms etc/webmin/quota/config.new 
preserve_perms etc/webmin/raid/config.new 
preserve_perms etc/webmin/rbac/config.new 
preserve_perms etc/webmin/reload.new 
preserve_perms etc/webmin/restart.new 
preserve_perms etc/webmin/restart-by-force-kill.new 
preserve_perms etc/webmin/samba/config.new 
preserve_perms etc/webmin/sarg/config.new 
preserve_perms etc/webmin/sendmail/config.new 
preserve_perms etc/webmin/servers/config.new 
preserve_perms etc/webmin/sgiexports/config.new 
preserve_perms etc/webmin/shell/config.new 
preserve_perms etc/webmin/shorewall/config.new 
preserve_perms etc/webmin/shorewall6/config.new 
preserve_perms etc/webmin/smart-status/config.new 
preserve_perms etc/webmin/smf/config.new 
preserve_perms etc/webmin/software/config.new 
preserve_perms etc/webmin/spam/config.new 
preserve_perms etc/webmin/squid/config.new 
preserve_perms etc/webmin/sshd/config.new 
preserve_perms etc/webmin/start.new 
preserve_perms etc/webmin/status/config.new 
preserve_perms etc/webmin/stop.new 
preserve_perms etc/webmin/stunnel/config.new 
preserve_perms etc/webmin/syslog/config.new 
preserve_perms etc/webmin/syslog-ng/config.new 
preserve_perms etc/webmin/system-status/config.new 
preserve_perms etc/webmin/tcpwrappers/config.new 
preserve_perms etc/webmin/time/config.new 
preserve_perms etc/webmin/tunnel/config.new 
preserve_perms etc/webmin/updown/config.new 
preserve_perms etc/webmin/useradmin/config.new 
preserve_perms etc/webmin/usermin/config.new 
preserve_perms etc/webmin/var-path.new 
preserve_perms etc/webmin/version.new 
preserve_perms etc/webmin/webalizer/config.new 
preserve_perms etc/webmin/webmin/config.new 
preserve_perms etc/webmin/webmin.acl.new 
preserve_perms etc/webmin/webmincron/config.new 
preserve_perms etc/webmin/webminlog/config.new 
preserve_perms etc/webmin/xinetd/config.new 
preserve_perms etc/webmin/xterm/config.new 
preserve_perms etc/webmin/zones/config.new 
( cd usr/libexec/webmin ; rm -rf blue-theme )
( cd usr/libexec/webmin ; ln -sf gray-theme blue-theme )
