/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.http.download.impl;

import by.gdev.http.download.exeption.UploadFileException;
import by.gdev.http.upload.download.downloader.DownloadElement;
import by.gdev.http.upload.download.downloader.DownloaderStatusEnum;
import com.google.common.eventbus.EventBus;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.time.LocalTime;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadRunnableImpl
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(DownloadRunnableImpl.class);
    private volatile DownloaderStatusEnum status;
    private Queue<DownloadElement> downloadElements;
    private List<DownloadElement> processedElements;
    private CloseableHttpClient httpclient;
    private RequestConfig requestConfig;
    private EventBus eventBus;
    private int DEFAULT_MAX_ATTEMPTS = 3;

    public DownloadRunnableImpl(Queue<DownloadElement> downloadElements, List<DownloadElement> processedElements, CloseableHttpClient httpclient, RequestConfig requestConfig, EventBus eventBus) {
        this.downloadElements = downloadElements;
        this.processedElements = processedElements;
        this.httpclient = httpclient;
        this.requestConfig = requestConfig;
        this.eventBus = eventBus;
    }

    @Override
    public void run() {
        DownloadElement element;
        while (this.status.equals((Object)DownloaderStatusEnum.WORK) && !this.status.equals((Object)DownloaderStatusEnum.CANCEL) && Objects.nonNull(element = this.downloadElements.poll())) {
            try {
                this.download(element);
                element.getHandlers().forEach(post -> post.postProcessDownloadElement(element));
            }
            catch (Throwable e1) {
                element.setError(new UploadFileException(element.getRepo().getRepositories().get(0) + element.getMetadata().getRelativeUrl(), element.getMetadata().getPath(), e1.getLocalizedMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(DownloadElement element) throws IOException, InterruptedException {
        this.processedElements.add(element);
        File file = new File(element.getPathToDownload() + element.getMetadata().getPath());
        for (int attempt = 0; attempt < this.DEFAULT_MAX_ATTEMPTS; ++attempt) {
            try {
                BufferedInputStream in = null;
                BufferedOutputStream out = null;
                boolean resume = false;
                HttpGet httpGet = new HttpGet(element.getRepo().getRepositories().get(0) + element.getMetadata().getRelativeUrl());
                log.trace(String.valueOf(httpGet));
                try {
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    if (file.exists() && Objects.nonNull(element.getMetadata().getSha1()) && file.length() != element.getMetadata().getSize()) {
                        httpGet.addHeader("Range", "bytes= " + file.length() + "-" + element.getMetadata().getSize());
                        resume = true;
                    }
                    httpGet.setConfig(this.requestConfig);
                    CloseableHttpResponse response = this.httpclient.execute(httpGet);
                    HttpEntity entity = response.getEntity();
                    in = new BufferedInputStream(entity.getContent());
                    out = new BufferedOutputStream(new FileOutputStream(file, resume));
                    byte[] buffer = new byte[1024];
                    int curread = in.read(buffer);
                    while (curread != -1 && !this.status.equals((Object)DownloaderStatusEnum.CANCEL)) {
                        out.write(buffer, 0, curread);
                        curread = in.read(buffer);
                        element.setDownloadBytes(element.getDownloadBytes() + (long)curread);
                    }
                    this.eventBus.post((Object)element);
                    LocalTime endTime = LocalTime.now();
                    element.setEnd(endTime);
                    this.DEFAULT_MAX_ATTEMPTS = 1;
                }
                catch (Throwable throwable) {
                    httpGet.abort();
                    IOUtils.close(out);
                    IOUtils.close(in);
                    throw throwable;
                }
                httpGet.abort();
                IOUtils.close((Closeable)out);
                IOUtils.close((Closeable)in);
                continue;
            }
            catch (SocketTimeoutException e) {
                if (attempt != this.DEFAULT_MAX_ATTEMPTS) continue;
                throw new SocketTimeoutException();
            }
        }
    }

    public DownloaderStatusEnum getStatus() {
        return this.status;
    }

    public Queue<DownloadElement> getDownloadElements() {
        return this.downloadElements;
    }

    public List<DownloadElement> getProcessedElements() {
        return this.processedElements;
    }

    public CloseableHttpClient getHttpclient() {
        return this.httpclient;
    }

    public RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public int getDEFAULT_MAX_ATTEMPTS() {
        return this.DEFAULT_MAX_ATTEMPTS;
    }

    public void setStatus(DownloaderStatusEnum status) {
        this.status = status;
    }

    public void setDownloadElements(Queue<DownloadElement> downloadElements) {
        this.downloadElements = downloadElements;
    }

    public void setProcessedElements(List<DownloadElement> processedElements) {
        this.processedElements = processedElements;
    }

    public void setHttpclient(CloseableHttpClient httpclient) {
        this.httpclient = httpclient;
    }

    public void setRequestConfig(RequestConfig requestConfig) {
        this.requestConfig = requestConfig;
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void setDEFAULT_MAX_ATTEMPTS(int DEFAULT_MAX_ATTEMPTS) {
        this.DEFAULT_MAX_ATTEMPTS = DEFAULT_MAX_ATTEMPTS;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DownloadRunnableImpl)) {
            return false;
        }
        DownloadRunnableImpl other = (DownloadRunnableImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DownloaderStatusEnum this$status = this.getStatus();
        DownloaderStatusEnum other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        Queue<DownloadElement> this$downloadElements = this.getDownloadElements();
        Queue<DownloadElement> other$downloadElements = other.getDownloadElements();
        if (this$downloadElements == null ? other$downloadElements != null : !this$downloadElements.equals(other$downloadElements)) {
            return false;
        }
        List<DownloadElement> this$processedElements = this.getProcessedElements();
        List<DownloadElement> other$processedElements = other.getProcessedElements();
        if (this$processedElements == null ? other$processedElements != null : !((Object)this$processedElements).equals(other$processedElements)) {
            return false;
        }
        CloseableHttpClient this$httpclient = this.getHttpclient();
        CloseableHttpClient other$httpclient = other.getHttpclient();
        if (this$httpclient == null ? other$httpclient != null : !this$httpclient.equals(other$httpclient)) {
            return false;
        }
        RequestConfig this$requestConfig = this.getRequestConfig();
        RequestConfig other$requestConfig = other.getRequestConfig();
        if (this$requestConfig == null ? other$requestConfig != null : !this$requestConfig.equals(other$requestConfig)) {
            return false;
        }
        EventBus this$eventBus = this.getEventBus();
        EventBus other$eventBus = other.getEventBus();
        if (this$eventBus == null ? other$eventBus != null : !this$eventBus.equals(other$eventBus)) {
            return false;
        }
        return this.getDEFAULT_MAX_ATTEMPTS() == other.getDEFAULT_MAX_ATTEMPTS();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DownloadRunnableImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DownloaderStatusEnum $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        Queue<DownloadElement> $downloadElements = this.getDownloadElements();
        result = result * 59 + ($downloadElements == null ? 43 : $downloadElements.hashCode());
        List<DownloadElement> $processedElements = this.getProcessedElements();
        result = result * 59 + ($processedElements == null ? 43 : ((Object)$processedElements).hashCode());
        CloseableHttpClient $httpclient = this.getHttpclient();
        result = result * 59 + ($httpclient == null ? 43 : $httpclient.hashCode());
        RequestConfig $requestConfig = this.getRequestConfig();
        result = result * 59 + ($requestConfig == null ? 43 : $requestConfig.hashCode());
        EventBus $eventBus = this.getEventBus();
        result = result * 59 + ($eventBus == null ? 43 : $eventBus.hashCode());
        result = result * 59 + this.getDEFAULT_MAX_ATTEMPTS();
        return result;
    }

    public String toString() {
        return "DownloadRunnableImpl(status=" + (Object)((Object)this.getStatus()) + ", downloadElements=" + this.getDownloadElements() + ", processedElements=" + this.getProcessedElements() + ", httpclient=" + this.getHttpclient() + ", requestConfig=" + this.getRequestConfig() + ", eventBus=" + this.getEventBus() + ", DEFAULT_MAX_ATTEMPTS=" + this.getDEFAULT_MAX_ATTEMPTS() + ")";
    }
}

