/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.util.model.download;

import by.gdev.util.DesktopUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.List;

public class Metadata {
    private String sha1;
    private long size;
    private String path;
    private List<String> urls;
    private String relativeUrl;
    private boolean executable;
    private String link;

    public static Metadata createMetadata(Path config) throws NoSuchAlgorithmException, IOException {
        Metadata metadata = new Metadata();
        metadata.setPath(config.toString().replace("\\", "/"));
        metadata.setRelativeUrl(config.toString().replace("\\", "/"));
        metadata.setSha1(DesktopUtil.getChecksum(config.toFile(), "sha-1"));
        return metadata;
    }

    public String getSha1() {
        return this.sha1;
    }

    public long getSize() {
        return this.size;
    }

    public String getPath() {
        return this.path;
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public String getRelativeUrl() {
        return this.relativeUrl;
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public String getLink() {
        return this.link;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setUrls(List<String> urls) {
        this.urls = urls;
    }

    public void setRelativeUrl(String relativeUrl) {
        this.relativeUrl = relativeUrl;
    }

    public void setExecutable(boolean executable) {
        this.executable = executable;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Metadata)) {
            return false;
        }
        Metadata other = (Metadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sha1 = this.getSha1();
        String other$sha1 = other.getSha1();
        if (this$sha1 == null ? other$sha1 != null : !this$sha1.equals(other$sha1)) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        List<String> this$urls = this.getUrls();
        List<String> other$urls = other.getUrls();
        if (this$urls == null ? other$urls != null : !((Object)this$urls).equals(other$urls)) {
            return false;
        }
        String this$relativeUrl = this.getRelativeUrl();
        String other$relativeUrl = other.getRelativeUrl();
        if (this$relativeUrl == null ? other$relativeUrl != null : !this$relativeUrl.equals(other$relativeUrl)) {
            return false;
        }
        if (this.isExecutable() != other.isExecutable()) {
            return false;
        }
        String this$link = this.getLink();
        String other$link = other.getLink();
        return !(this$link == null ? other$link != null : !this$link.equals(other$link));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Metadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sha1 = this.getSha1();
        result = result * 59 + ($sha1 == null ? 43 : $sha1.hashCode());
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        List<String> $urls = this.getUrls();
        result = result * 59 + ($urls == null ? 43 : ((Object)$urls).hashCode());
        String $relativeUrl = this.getRelativeUrl();
        result = result * 59 + ($relativeUrl == null ? 43 : $relativeUrl.hashCode());
        result = result * 59 + (this.isExecutable() ? 79 : 97);
        String $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : $link.hashCode());
        return result;
    }

    public String toString() {
        return "Metadata(sha1=" + this.getSha1() + ", size=" + this.getSize() + ", path=" + this.getPath() + ", urls=" + this.getUrls() + ", relativeUrl=" + this.getRelativeUrl() + ", executable=" + this.isExecutable() + ", link=" + this.getLink() + ")";
    }
}

