/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.modpack.domain.client.share;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.tlauncher.modpack.domain.client.share.GameType;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum Category {
    ALL,
    MAGIC,
    ADVENTURE_RPG,
    COSMETIC,
    ARMOR_WEAPONS_TOOLS,
    TECHNOLOGY,
    MAP_INFORMATION,
    LIBRARY_API,
    CHITA,
    ADDONS_FORESTRY,
    TECHNOLOGY_FARMING,
    ADDONS_THERMALEXPANSION,
    TECHNOLOGY_ENERGY,
    WORLD_MOBS,
    WORLD_BIOMES,
    SERVER_UTILITY,
    BLOOD_MAGIC,
    WORLD_DIMENSIONS,
    ADDONS_BUILDCRAFT,
    APPLIED_ENERGISTICS_2,
    TECHNOLOGY_ITEM_FLUID_ENERGY_TRANSPORT,
    TECHNOLOGY_PLAYER_TRANSPORT,
    MC_MISCELLANEOUS,
    WORLD_ORES_RESOURCES,
    MC_FOOD,
    REDSTONE,
    MC_ADDONS,
    WORLD_STRUCTURES,
    ADDONS_INDUSTRIALCRAFT,
    WORLD_GEN,
    TECHNOLOGY_PROCESSING,
    ADDONS_THAUMCRAFT,
    ADDONS_TINKERS_CONSTRUCT,
    TECHNOLOGY_GENETICS,
    ADVENTURE,
    CREATION,
    GAME_MAP,
    PARKOUR,
    SURVIVAL,
    PUZZLE,
    MODDED_WORLD,
    SIXTEEN_X,
    THIRTY_TWO_X,
    SIXTY_FOUR_X,
    ONE_TWENTY_EIGHT_X,
    TWO_FIFTY_SIX_X,
    FIVE_TWELVE_X_AND_BEYOND,
    ANIMATED,
    MEDIEVAL,
    MOD_SUPPORT,
    MODERN,
    PHOTO_REALISTIC,
    STEAMPUNK,
    TRADITIONAL,
    MISCELLANEOUS,
    ADVENTURE_AND_RPG,
    COMBAT_PVP,
    FTB_OFFICIAL_PACK,
    HARDCORE,
    MAP_BASED,
    MINI_GAME,
    MULTIPLAYER,
    QUESTS,
    SCI_FI,
    TECH,
    EXPLORATION,
    EXTRA_LARGE,
    SMALL_LIGHT,
    LUCKY_BLOCKS,
    CRAFTTWEAKER,
    HARDCORE_QUESTING_MODE,
    CONFIGURATION,
    SCRIPTS,
    RECIPES,
    BUILDING_GADGETS,
    PROGRESSION,
    GUIDEBOOK,
    REALISTIC,
    LAG_LESS,
    LOW_END,
    PSYCHEDELIC,
    CUSTOMIZATION,
    SHADERPACKS,
    STORAGE,
    FABRIC,
    TWITCH_INTEGRATION,
    SKYBLOCK;

    public static final Map<Category, Integer> common;
    public static final Map<Category, Integer> shaderMap;

    @JsonCreator
    public static Category createCategory(String value) {
        return Category.valueOf(value.toUpperCase());
    }

    @JsonValue
    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static Category[] getCategories(GameType type) {
        switch (type) {
            case MODPACK: {
                return new Category[]{ALL, ADVENTURE_AND_RPG, COMBAT_PVP, EXPLORATION, EXTRA_LARGE, FTB_OFFICIAL_PACK, HARDCORE, MAGIC, MAP_BASED, MINI_GAME, MULTIPLAYER, QUESTS, SCI_FI, SMALL_LIGHT, TECH, SKYBLOCK};
            }
            case MOD: {
                return new Category[]{ALL, ADVENTURE_RPG, ARMOR_WEAPONS_TOOLS, COSMETIC, MC_FOOD, MAGIC, MAP_INFORMATION, REDSTONE, SERVER_UTILITY, TECHNOLOGY, TECHNOLOGY_ENERGY, TECHNOLOGY_ITEM_FLUID_ENERGY_TRANSPORT, TECHNOLOGY_FARMING, TECHNOLOGY_GENETICS, TECHNOLOGY_PLAYER_TRANSPORT, TECHNOLOGY_PROCESSING, WORLD_GEN, WORLD_BIOMES, WORLD_DIMENSIONS, WORLD_MOBS, WORLD_ORES_RESOURCES, WORLD_STRUCTURES, MC_ADDONS, APPLIED_ENERGISTICS_2, BLOOD_MAGIC, ADDONS_BUILDCRAFT, ADDONS_FORESTRY, ADDONS_INDUSTRIALCRAFT, ADDONS_THAUMCRAFT, ADDONS_THERMALEXPANSION, ADDONS_TINKERS_CONSTRUCT, LIBRARY_API, MC_MISCELLANEOUS, CHITA, FABRIC, TWITCH_INTEGRATION, STORAGE};
            }
            case MAP: {
                return new Category[]{ALL, ADVENTURE, CREATION, GAME_MAP, MODDED_WORLD, PARKOUR, PUZZLE, SURVIVAL};
            }
            case RESOURCEPACK: {
                return new Category[]{ALL, SIXTEEN_X, THIRTY_TWO_X, SIXTY_FOUR_X, ONE_TWENTY_EIGHT_X, TWO_FIFTY_SIX_X, FIVE_TWELVE_X_AND_BEYOND, ANIMATED, MEDIEVAL, MOD_SUPPORT, MODERN, PHOTO_REALISTIC, STEAMPUNK, TRADITIONAL, MISCELLANEOUS};
            }
            case SHADERPACK: {
                return new Category[]{ALL, SHADERPACKS, REALISTIC, LAG_LESS, LOW_END, PSYCHEDELIC, CUSTOMIZATION, CONFIGURATION, LUCKY_BLOCKS, GUIDEBOOK, QUESTS, HARDCORE_QUESTING_MODE, PROGRESSION, SCRIPTS, CRAFTTWEAKER, RECIPES, WORLD_GEN, BUILDING_GADGETS};
            }
        }
        return null;
    }

    public static Map<Category, Integer> getSubCategories(GameType type) {
        switch (type) {
            case MODPACK: 
            case MOD: 
            case MAP: 
            case RESOURCEPACK: {
                return common;
            }
            case SHADERPACK: {
                return shaderMap;
            }
        }
        return new HashMap<Category, Integer>();
    }

    static {
        common = new HashMap<Category, Integer>(){
            {
                this.put(TECHNOLOGY_ENERGY, 2);
                this.put(TECHNOLOGY_ENERGY, 2);
                this.put(TECHNOLOGY_ITEM_FLUID_ENERGY_TRANSPORT, 2);
                this.put(TECHNOLOGY_FARMING, 2);
                this.put(TECHNOLOGY_GENETICS, 2);
                this.put(TECHNOLOGY_PLAYER_TRANSPORT, 2);
                this.put(TECHNOLOGY_PROCESSING, 2);
                this.put(WORLD_BIOMES, 2);
                this.put(WORLD_DIMENSIONS, 2);
                this.put(WORLD_MOBS, 2);
                this.put(WORLD_ORES_RESOURCES, 2);
                this.put(WORLD_STRUCTURES, 2);
                this.put(APPLIED_ENERGISTICS_2, 2);
                this.put(BLOOD_MAGIC, 2);
                this.put(ADDONS_BUILDCRAFT, 2);
                this.put(ADDONS_FORESTRY, 2);
                this.put(ADDONS_INDUSTRIALCRAFT, 2);
                this.put(ADDONS_THAUMCRAFT, 2);
                this.put(ADDONS_THERMALEXPANSION, 2);
                this.put(ADDONS_TINKERS_CONSTRUCT, 2);
                this.put(HARDCORE_QUESTING_MODE, 2);
                this.put(PROGRESSION, 2);
                this.put(CRAFTTWEAKER, 2);
                this.put(RECIPES, 2);
                this.put(BUILDING_GADGETS, 2);
                this.put(CONFIGURATION, 2);
                this.put(GUIDEBOOK, 2);
            }
        };
        shaderMap = new HashMap<Category, Integer>(){
            {
                this.put(CONFIGURATION, 2);
                this.put(LUCKY_BLOCKS, 3);
                this.put(GUIDEBOOK, 2);
                this.put(QUESTS, 2);
                this.put(HARDCORE_QUESTING_MODE, 3);
                this.put(PROGRESSION, 3);
                this.put(SCRIPTS, 2);
                this.put(CRAFTTWEAKER, 3);
                this.put(RECIPES, 3);
                this.put(WORLD_GEN, 3);
                this.put(BUILDING_GADGETS, 3);
                this.put(REALISTIC, 2);
                this.put(LAG_LESS, 2);
                this.put(LOW_END, 2);
                this.put(PSYCHEDELIC, 2);
            }
        };
    }
}

