/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.modpack.domain.client.share;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.MapDTO;
import org.tlauncher.modpack.domain.client.ModDTO;
import org.tlauncher.modpack.domain.client.ModpackDTO;
import org.tlauncher.modpack.domain.client.ResourcePackDTO;
import org.tlauncher.modpack.domain.client.ShaderpackDTO;
import org.tlauncher.modpack.domain.client.version.ModVersionDTO;
import org.tlauncher.modpack.domain.client.version.ModpackVersionDTO;
import org.tlauncher.modpack.domain.client.version.VersionDTO;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum GameType {
    MAP,
    MOD,
    MODPACK,
    RESOURCEPACK,
    NOT_MODPACK,
    SHADERPACK;


    @JsonValue
    public String toLowerCase() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String toWebParam() {
        return this.name().toUpperCase(Locale.ROOT);
    }

    @JsonCreator
    public static GameType create(String value) {
        return GameType.valueOf(value.toUpperCase());
    }

    public static Class<? extends GameEntityDTO> createDTO(GameType type) {
        switch (type) {
            case MAP: {
                return MapDTO.class;
            }
            case MOD: {
                return ModDTO.class;
            }
            case RESOURCEPACK: {
                return ResourcePackDTO.class;
            }
            case MODPACK: {
                return ModpackDTO.class;
            }
            case SHADERPACK: {
                return ShaderpackDTO.class;
            }
        }
        throw new NullPointerException();
    }

    public static Class<? extends VersionDTO> createVersionDTO(GameType type) {
        switch (type) {
            case MAP: {
                return VersionDTO.class;
            }
            case MOD: {
                return ModVersionDTO.class;
            }
            case RESOURCEPACK: {
                return VersionDTO.class;
            }
            case MODPACK: {
                return ModpackVersionDTO.class;
            }
            case SHADERPACK: {
                return VersionDTO.class;
            }
        }
        throw new NullPointerException();
    }

    public static GameType create(Class<? extends GameEntityDTO> c) {
        return GameType.create(c.getSimpleName().replaceAll("DTO", ""));
    }

    public static List<GameType> getSubEntities() {
        return new ArrayList<GameType>(){
            {
                this.add(MOD);
                this.add(MAP);
                this.add(RESOURCEPACK);
                this.add(SHADERPACK);
            }
        };
    }

    public static List<String> getPluralWords() {
        return GameType.getExistedGameTypes().stream().map(GameType::getPluralStringWord).collect(Collectors.toList());
    }

    public static String getPluralStringWord(GameType type) {
        return type.name().toLowerCase(Locale.ROOT) + "s";
    }

    public static List<GameType> getExistedGameTypes() {
        return new ArrayList<GameType>(){
            {
                this.add(MOD);
                this.add(MODPACK);
                this.add(RESOURCEPACK);
                this.add(MAP);
                this.add(SHADERPACK);
            }
        };
    }
}

