/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.serialization.version;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Date;
import net.minecraft.launcher.versions.ModifiedVersion;
import net.minecraft.launcher.versions.json.DateTypeAdapter;
import net.minecraft.launcher.versions.json.RepoTypeAdapter;
import org.tlauncher.modpack.domain.client.ModpackDTO;
import org.tlauncher.tlauncher.repository.Repo;
import org.tlauncher.util.gson.serializer.ModpackDTOTypeAdapter;

public class ModifiedVersionSerializer
implements JsonSerializer<ModifiedVersion>,
JsonDeserializer<ModifiedVersion> {
    private final Gson defaultContext;

    public ModifiedVersionSerializer() {
        GsonBuilder remoteBuilder = new GsonBuilder();
        remoteBuilder.registerTypeAdapter((Type)((Object)Repo.class), new RepoTypeAdapter());
        remoteBuilder.registerTypeAdapter((Type)((Object)ModpackDTO.class), new ModpackDTOTypeAdapter());
        remoteBuilder.registerTypeAdapter((Type)((Object)Date.class), new DateTypeAdapter());
        remoteBuilder.enableComplexMapKeySerialization();
        remoteBuilder.disableHtmlEscaping();
        remoteBuilder.setPrettyPrinting();
        this.defaultContext = remoteBuilder.create();
    }

    @Override
    public ModifiedVersion deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject object = jsonElement.getAsJsonObject();
        return this.defaultContext.fromJson((JsonElement)object, ModifiedVersion.class);
    }

    @Override
    public JsonElement serialize(ModifiedVersion modifiedVersion, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonElement = (JsonObject)this.defaultContext.toJsonTree(modifiedVersion, type);
        JsonElement jar = jsonElement.get("jar");
        if (jar == null) {
            jsonElement.remove("downloadJarLibraries");
        }
        if (jsonElement.has("userConfigSkinVersion")) {
            jsonElement.remove("userConfigSkinVersion");
        }
        return jsonElement;
    }
}

