/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.component;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.LogClient;
import org.tlauncher.modpack.domain.client.version.MetadataDTO;
import org.tlauncher.tlauncher.downloader.Downloadable;
import org.tlauncher.tlauncher.downloader.DownloadableContainer;
import org.tlauncher.tlauncher.repository.ClientInstanceRepo;
import org.tlauncher.util.FileUtil;

public class LogClientConfigurationComponent {
    private LogClient.LogClientFile validateLogClientXmlResource(CompleteVersion version, File gameDir) {
        LogClient.LogClientFile l;
        if (this.isNotNullLogClient(version) && !(l = this.getLogClient(version).getFile()).getSha1().equals(FileUtil.getChecksum(this.buildPathLogXmlConfiguration(gameDir, this.getLogClient(version)).toFile()))) {
            return l;
        }
        return null;
    }

    public DownloadableContainer getContainer(CompleteVersion version, File gameDir, boolean forceUpdate) {
        DownloadableContainer container = new DownloadableContainer();
        LogClient.LogClientFile l = this.validateLogClientXmlResource(version, gameDir);
        if (Objects.isNull(l)) {
            return container;
        }
        MetadataDTO m = new MetadataDTO();
        m.setLocalDestination(Paths.get(gameDir.toString(), "assets", "log_configs", l.getId()).toFile());
        m.setSha1(l.getSha1());
        m.setUrl(l.getUrl());
        m.setSize(l.getSize());
        Downloadable d = new Downloadable(ClientInstanceRepo.EMPTY_REPO, m, forceUpdate);
        container.add(d);
        return container;
    }

    public Path buildPathLogXmlConfiguration(File gameDir, LogClient l) {
        return Paths.get(gameDir.getAbsolutePath(), "assets", "log_configs", l.getFile().getId());
    }

    public LogClient getLogClient(CompleteVersion v) {
        LogClient c;
        if (Objects.nonNull(v.getLogging()) && Objects.nonNull(c = v.getLogging().get("client")) && Objects.nonNull(c.getFile())) {
            return c;
        }
        return null;
    }

    public boolean isNotNullLogClient(CompleteVersion v) {
        return !Objects.isNull(this.getLogClient(v));
    }
}

