/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.downloader;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.tlauncher.tlauncher.downloader.AbortedDownloadException;
import org.tlauncher.tlauncher.downloader.Downloadable;
import org.tlauncher.tlauncher.downloader.Downloader;
import org.tlauncher.tlauncher.downloader.GaveUpDownloadException;
import org.tlauncher.tlauncher.downloader.RetryDownloadException;
import org.tlauncher.tlauncher.repository.ClientInstanceRepo;
import org.tlauncher.tlauncher.repository.Repo;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.async.ExtendedThread;

public class DownloaderThread
extends ExtendedThread {
    private static final String ITERATION_BLOCK = "iteration";
    private final int ID;
    private final String LOGGER_PREFIX;
    private final Downloader downloader;
    private final List<Downloadable> list;
    private Downloadable current;
    private boolean launched;
    private boolean initDownloadedLink;
    private String incorrectUrl = "";

    DownloaderThread(Downloader d, int id) {
        super("DT#" + id);
        this.ID = id;
        this.LOGGER_PREFIX = "[D#" + id + "]";
        this.downloader = d;
        this.list = new ArrayList<Downloadable>();
        this.startAndWait();
    }

    int getID() {
        return this.ID;
    }

    void add(Downloadable d) {
        this.list.add(d);
    }

    void startDownload() {
        this.launched = true;
        this.unlockThread(ITERATION_BLOCK);
    }

    void stopDownload() {
        this.launched = false;
    }

    @Override
    public void run() {
        while (true) {
            this.launched = true;
            Iterator<Downloadable> iterator = this.list.iterator();
            while (iterator.hasNext()) {
                int max;
                Downloadable d;
                this.current = d = iterator.next();
                this.onStart();
                int attempt = 0;
                Exception error = null;
                this.initDownloadedLink = false;
                while (attempt < (max = this.downloader.getConfiguration().getTries(d.isFast()))) {
                    int timeout = ++attempt * this.downloader.getConfiguration().getTimeout();
                    try {
                        this.download(timeout);
                        break;
                    }
                    catch (GaveUpDownloadException e) {
                        this.dlog("File is not reachable at all.");
                        error = e;
                    }
                    catch (AbortedDownloadException e) {
                        this.dlog("This download process has been aborted.");
                        error = e;
                        break;
                    }
                    if (attempt < max) continue;
                    FileUtil.deleteFile(d.getMetadataDTO().getLocalDestination());
                    for (File file : d.getAdditionalDestinations()) {
                        FileUtil.deleteFile(file);
                    }
                    this.dlog("Gave up trying to download this file.", error);
                    this.onError(error);
                }
                if (!(error instanceof AbortedDownloadException)) continue;
                this.tlog("Thread is aborting...");
                for (Downloadable downloadable : this.list) {
                    downloadable.onAbort((AbortedDownloadException)error);
                }
            }
            this.list.clear();
            this.lockThread(ITERATION_BLOCK);
            this.launched = false;
        }
    }

    private void download(int timeout) throws GaveUpDownloadException, AbortedDownloadException {
        boolean hasRepo = this.current.hasRepository();
        int max = hasRepo ? this.current.getRepository().getCount() : 1;
        IOException cause = null;
        for (int attempt = 0; attempt < max; ++attempt) {
            String url = "";
            try {
                Repo r;
                url = hasRepo ? ((r = this.current.getRepository()).equals(ClientInstanceRepo.EMPTY_REPO) && attempt == 1 ? this.current.getRepository().getRepo(attempt) + URLEncoder.encode(this.current.getMetadataDTO().getUrl(), StandardCharsets.UTF_8.name()) : this.current.getRepository().getRepo(attempt) + this.current.getMetadataDTO().getUrl()) : this.current.getMetadataDTO().getUrl();
                this.dlog(url);
                this.downloadURL(url, timeout);
                return;
            }
            catch (IOException e) {
                this.dlog("Failed to download from: ", url, e);
                if (!this.initDownloadedLink) {
                    this.incorrectUrl = url;
                    this.initDownloadedLink = true;
                }
                cause = e;
                continue;
            }
        }
        throw new GaveUpDownloadException(this.incorrectUrl + " -> " + this.current.getMetadataDTO().getLocalDestination(), cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void downloadURL(String url, int timeout) throws IOException, AbortedDownloadException {
        if (!this.launched) {
            throw new AbortedDownloadException();
        }
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        File file = this.current.getMetadataDTO().getLocalDestination();
        File temp = FileUtil.makeTemp(new File(file.getAbsolutePath() + ".tlauncherdownload"));
        HttpGet g = new HttpGet(url);
        try {
            long downloaded_s;
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout).setSocketTimeout(timeout).build();
            g.setConfig(requestConfig);
            CloseableHttpResponse r = this.downloader.getClient().execute(g);
            HttpEntity entity = r.getEntity();
            if (r.getStatusLine().getStatusCode() != 200) {
                EntityUtils.consume(entity);
                throw new IOException(String.valueOf(r.getStatusLine().getStatusCode()));
            }
            in = new BufferedInputStream(entity.getContent());
            if (this.current.getMetadataDTO().getSize() == 0L) {
                this.current.getMetadataDTO().setSize(entity.getContentLength());
            }
            this.current.setAlreadyDownloaded(0L);
            out = new BufferedOutputStream(new FileOutputStream(temp));
            long speed_s = downloaded_s = System.currentTimeMillis();
            byte[] buffer = new byte[65536];
            int curread = ((InputStream)in).read(buffer);
            while (curread != -1) {
                if (!this.launched) {
                    throw new AbortedDownloadException();
                }
                ((OutputStream)out).write(buffer, 0, curread);
                curread = ((InputStream)in).read(buffer);
                if (curread != -1) {
                    this.current.setAlreadyDownloaded(this.current.getAlreadyDownloaded() + (long)curread);
                    long speed_e = System.currentTimeMillis() - speed_s;
                    if (speed_e < 300L) continue;
                    speed_s = System.currentTimeMillis();
                    this.downloader.onProgress();
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            g.abort();
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        g.abort();
        IOUtils.closeQuietly(in);
        IOUtils.closeQuietly(out);
        Files.deleteIfExists(file.toPath());
        Files.move(temp.toPath(), file.toPath(), new CopyOption[0]);
        List<File> copies = this.current.getAdditionalDestinations();
        if (copies.size() > 0) {
            this.dlog("Found additional destinations. Copying...");
            for (File copy : copies) {
                this.dlog("Copying " + copy + "...");
                FileUtil.copyFile(file, copy, this.current.isForce());
                this.dlog("Success!");
            }
            this.dlog("Copying completed.");
        }
        this.onComplete();
    }

    private void onStart() {
        this.current.onStart();
    }

    private void onError(Throwable e) {
        this.current.onError(e);
        this.downloader.onFileComplete(this.current);
    }

    private void onComplete() throws RetryDownloadException {
        this.current.onComplete();
        this.downloader.onProgress();
        this.downloader.onFileComplete(this.current);
    }

    private void tlog(Object ... o) {
        U.plog(this.LOGGER_PREFIX, o);
    }

    private void dlog(String message, String url, Throwable ex) {
        if (ex == null) {
            U.plog(this.LOGGER_PREFIX, "> ", message, url);
        } else {
            U.plog(this.LOGGER_PREFIX, "> ", message, url, ex);
        }
    }

    private void dlog(String message) {
        this.dlog(message, "", null);
    }

    private void dlog(String message, Throwable ex) {
        this.dlog(message, "", ex);
    }
}

