/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.managers;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tlauncher.tlauncher.component.ComponentDependence;
import org.tlauncher.tlauncher.component.InterruptibleComponent;
import org.tlauncher.tlauncher.component.LauncherComponent;
import org.tlauncher.tlauncher.component.RefreshableComponent;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.util.async.LoopedThread;

public class ComponentManager {
    private TLauncher tlauncher;
    private final List<LauncherComponent> components;
    private final ComponentManagerRefresher refresher;

    public ComponentManager(TLauncher tLauncher) {
        this.tlauncher = tLauncher;
        this.components = Collections.synchronizedList(new ArrayList());
        this.refresher = new ComponentManagerRefresher(this);
        this.refresher.start();
    }

    public TLauncher getLauncher() {
        return this.tlauncher;
    }

    public <T extends LauncherComponent> T loadComponent(Class<T> classOfT) {
        if (classOfT == null) {
            throw new NullPointerException();
        }
        if (this.hasComponent(classOfT)) {
            return this.getComponent(classOfT);
        }
        ComponentDependence dependence = classOfT.getAnnotation(ComponentDependence.class);
        if (dependence != null) {
            for (Class<?> requiredClass : dependence.value()) {
                this.rawLoadComponent(requiredClass);
            }
        }
        return (T)((LauncherComponent)this.rawLoadComponent(classOfT));
    }

    private <T> T rawLoadComponent(Class<T> classOfT) {
        T instance;
        Constructor<T> constructor;
        if (classOfT == null) {
            throw new NullPointerException();
        }
        if (!LauncherComponent.class.isAssignableFrom(classOfT)) {
            throw new IllegalArgumentException("Given class is not a LauncherComponent: " + classOfT.getSimpleName());
        }
        try {
            constructor = classOfT.getConstructor(ComponentManager.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get constructor for component: " + classOfT.getSimpleName(), e);
        }
        try {
            instance = constructor.newInstance(this);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot createScrollWrapper a new instance for component: " + classOfT.getSimpleName(), e);
        }
        LauncherComponent component = (LauncherComponent)instance;
        this.components.add(component);
        return instance;
    }

    public <T extends LauncherComponent> T getComponent(Class<T> classOfT) {
        if (classOfT == null) {
            throw new NullPointerException();
        }
        for (LauncherComponent component : this.components) {
            if (!classOfT.isInstance(component)) continue;
            return (T)component;
        }
        throw new IllegalArgumentException("Cannot find the component!");
    }

    <T extends LauncherComponent> boolean hasComponent(Class<T> classOfT) {
        if (classOfT == null) {
            return false;
        }
        for (LauncherComponent component : this.components) {
            if (!classOfT.isInstance(component)) continue;
            return true;
        }
        return false;
    }

    public <T> List<T> getComponentsOf(Class<T> classOfE) {
        ArrayList<LauncherComponent> list = new ArrayList<LauncherComponent>();
        if (classOfE == null) {
            return list;
        }
        for (LauncherComponent component : this.components) {
            if (!classOfE.isInstance(component)) continue;
            list.add(component);
        }
        return list;
    }

    public void startAsyncRefresh() {
        this.refresher.iterate();
    }

    void startRefresh() {
        for (LauncherComponent component : this.components) {
            if (!(component instanceof RefreshableComponent)) continue;
            RefreshableComponent interruptible = (RefreshableComponent)component;
            interruptible.refreshComponent();
        }
    }

    public void stopRefresh() {
        for (LauncherComponent component : this.components) {
            if (!(component instanceof InterruptibleComponent)) continue;
            InterruptibleComponent interruptible = (InterruptibleComponent)component;
            interruptible.stopRefresh();
        }
    }

    public void setTlauncher(TLauncher tlauncher) {
        this.tlauncher = tlauncher;
    }

    class ComponentManagerRefresher
    extends LoopedThread {
        private final ComponentManager parent;

        ComponentManagerRefresher(ComponentManager manager) {
            super("ComponentManagerRefresher");
            this.parent = manager;
        }

        @Override
        protected void iterateOnce() {
            this.parent.startRefresh();
        }
    }
}

