/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.minecraft.launcher;

import ch.jamiete.mcping.MinecraftPing;
import ch.jamiete.mcping.MinecraftPingOptions;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.name.Named;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.SwingUtilities;
import net.minecraft.launcher.process.JavaProcess;
import net.minecraft.launcher.process.JavaProcessLauncher;
import net.minecraft.launcher.process.JavaProcessListener;
import net.minecraft.launcher.updater.AssetIndex;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.ExtractRules;
import net.minecraft.launcher.versions.Library;
import net.minecraft.launcher.versions.LogClient;
import net.minecraft.launcher.versions.json.Argument;
import net.minecraft.launcher.versions.json.ArgumentType;
import net.minecraft.launcher.versions.json.DateTypeAdapter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.tlauncher.tlauncher.component.LogClientConfigurationComponent;
import org.tlauncher.tlauncher.component.minecraft.JavaMinecraftComponent;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.configuration.enums.ActionOnLaunch;
import org.tlauncher.tlauncher.downloader.AbortedDownloadException;
import org.tlauncher.tlauncher.downloader.DefaultDownloadableContainerHandler;
import org.tlauncher.tlauncher.downloader.DownloadableContainer;
import org.tlauncher.tlauncher.downloader.Downloader;
import org.tlauncher.tlauncher.entity.minecraft.MinecraftJava;
import org.tlauncher.tlauncher.entity.server.RemoteServer;
import org.tlauncher.tlauncher.entity.server.Server;
import org.tlauncher.tlauncher.managers.AssetsManager;
import org.tlauncher.tlauncher.managers.ComponentManager;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.managers.ProfileManager;
import org.tlauncher.tlauncher.managers.VersionManager;
import org.tlauncher.tlauncher.managers.VersionSyncInfoContainer;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.minecraft.crash.Crash;
import org.tlauncher.tlauncher.minecraft.crash.CrashDescriptor;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftException;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftExtendedListener;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftListener;
import org.tlauncher.tlauncher.minecraft.launcher.assitent.AdditionalFileAssistanceFactory;
import org.tlauncher.tlauncher.minecraft.launcher.assitent.BackupWorldAssistant;
import org.tlauncher.tlauncher.minecraft.launcher.assitent.MinecraftLauncherAssistantInterface;
import org.tlauncher.tlauncher.modpack.ModpackUtil;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.service.XmlLogDeserialization;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.alert.Notification;
import org.tlauncher.tlauncher.ui.console.Console;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.swing.notification.skin.SkinNotification;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.MinecraftUtil;
import org.tlauncher.util.OS;
import org.tlauncher.util.U;
import org.tlauncher.util.guice.LanguageAssistFactory;
import org.tlauncher.util.guice.SoundAssistFactory;

public class MinecraftLauncher
implements JavaProcessListener {
    private final Thread parentThread;
    private final Gson gson;
    private final DateTypeAdapter dateAdapter;
    private final Downloader downloader;
    private final Configuration settings;
    private final boolean forceUpdate;
    private final boolean assistLaunch;
    private final VersionManager vm;
    private final AssetsManager am;
    private final ProfileManager pm;
    private final List<MinecraftListener> listeners;
    private final List<MinecraftExtendedListener> extListeners;
    private final List<MinecraftLauncherAssistantInterface> assistants = new ArrayList<MinecraftLauncherAssistantInterface>();
    private boolean working;
    private boolean killed;
    @Named(value="console")
    @Inject
    private Console console;
    private final CrashDescriptor descriptor;
    private MinecraftLauncherStep step;
    @Inject
    private ModpackManager modpackManager;
    @Inject
    private SoundAssistFactory soundAssistFactory;
    @Inject
    private AdditionalFileAssistanceFactory additionalFileAssistanceFactory;
    @Inject
    private LanguageAssistFactory languageAssistFactory;
    @Inject
    JavaMinecraftComponent javaMinecraftComponent;
    @Inject
    private BackupWorldAssistant backupWorldAssistant;
    @Inject
    private LogClientConfigurationComponent logClientConfigurationComponent;
    @Inject
    private XmlLogDeserialization xmlLogDeserialization;
    private String versionName;
    private VersionSyncInfo versionSync;
    private CompleteVersion version;
    private CompleteVersion deJureVersion;
    private Account account;
    private int javaVersion = 8;
    private MinecraftJava.CompleteMinecraftJava java;
    private File javaDir;
    private File gameDir;
    private File runningMinecraftDir;
    private File localAssetsDir;
    private File nativeDir;
    private File globalAssetsDir;
    private File assetsIndexesDir;
    private File assetsObjectsDir;
    private int[] windowSize;
    private boolean fullScreen;
    private int ramSize;
    private JavaProcessLauncher launcher;
    private String javaArgs;
    private String programArgs;
    private volatile boolean minecraftWorking;
    private long startupTime;
    private int exitCode;
    private RemoteServer server;
    private boolean clearNatives;
    private JavaProcess process;
    private boolean firstLine = true;

    private MinecraftLauncher(ComponentManager manager, Downloader downloader, Configuration configuration, boolean forceUpdate, ConsoleVisibility visibility, boolean exit) {
        if (manager == null) {
            throw new NullPointerException("Ti sovsem s duba ruhnul?");
        }
        if (downloader == null) {
            throw new NullPointerException("Downloader is NULL!");
        }
        if (configuration == null) {
            throw new NullPointerException("Configuration is NULL!");
        }
        if (visibility == null) {
            throw new NullPointerException("ConsoleVisibility is NULL!");
        }
        this.parentThread = Thread.currentThread();
        this.gson = new Gson();
        this.dateAdapter = new DateTypeAdapter();
        this.downloader = downloader;
        this.settings = configuration;
        this.vm = manager.getComponent(VersionManager.class);
        this.am = manager.getComponent(AssetsManager.class);
        this.pm = manager.getComponent(ProfileManager.class);
        this.forceUpdate = forceUpdate;
        this.assistLaunch = !exit;
        this.descriptor = new CrashDescriptor(this);
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.extListeners = Collections.synchronizedList(new ArrayList());
        this.step = MinecraftLauncherStep.NONE;
        this.log("Running under TLauncher " + TLauncher.getVersion());
    }

    @Inject
    public MinecraftLauncher(@Assisted TLauncher t, @Assisted boolean forceUpdate) {
        this(t.getManager(), t.getDownloader(), t.getConfiguration(), forceUpdate, t.getConfiguration().getConsoleType().getVisibility(), t.getConfiguration().getActionOnLaunch() == ActionOnLaunch.EXIT);
    }

    @Inject
    public void postInit() {
        this.assistants.add(this.soundAssistFactory.create(this));
        this.assistants.add(this.additionalFileAssistanceFactory.create(this));
        this.assistants.add(this.languageAssistFactory.create(this));
        this.assistants.add(this.javaMinecraftComponent);
        this.assistants.add(this.backupWorldAssistant);
    }

    public Downloader getDownloader() {
        return this.downloader;
    }

    public Configuration getConfiguration() {
        return this.settings;
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public boolean isLaunchAssist() {
        return this.assistLaunch;
    }

    public CrashDescriptor getCrashDescriptor() {
        return this.descriptor;
    }

    public MinecraftLauncherStep getStep() {
        return this.step;
    }

    public boolean isWorking() {
        return this.working;
    }

    public void addListener(MinecraftListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (listener instanceof MinecraftExtendedListener) {
            this.extListeners.add((MinecraftExtendedListener)listener);
        }
        this.listeners.add(listener);
    }

    public void start() {
        this.checkWorking();
        this.working = true;
        try {
            this.collectInfo();
            this.downloadResources();
            this.checkExtraConditions();
            this.constructProcess();
            this.launchMinecraft();
            this.postLaunch();
        }
        catch (Throwable e) {
            this.log("Error occurred:", e);
            if (e instanceof MinecraftException) {
                if (!this.settings.getBoolean("memory.notification.off") && !FileUtil.checkFreeSpace(MinecraftUtil.getWorkingDirectory(), FileUtil.SIZE_300)) {
                    String message = Localizable.get("memory.notification.message").replace("disk", MinecraftUtil.getWorkingDirectory().toPath().getRoot().toString());
                    Alert.showCustomMonolog(Localizable.get("memory.notification.title"), new Notification(message, "memory.notification.off"));
                }
                MinecraftException me = (MinecraftException)e;
                for (MinecraftListener listener : this.listeners) {
                    listener.onMinecraftKnownError(me);
                }
            } else if (e instanceof MinecraftLauncherAborted) {
                for (MinecraftListener listener : this.listeners) {
                    listener.onMinecraftAbort();
                }
            } else {
                for (MinecraftListener listener : this.listeners) {
                    listener.onMinecraftError(e);
                }
            }
        }
        this.working = false;
        this.step = MinecraftLauncherStep.NONE;
        this.log("Launcher exited.");
    }

    public void stop() {
        if (this.step == MinecraftLauncherStep.NONE) {
            throw new IllegalStateException();
        }
        if (this.step == MinecraftLauncherStep.DOWNLOADING) {
            this.downloader.stopDownload();
        }
        this.working = false;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public CompleteVersion getVersion() {
        return this.version;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(RemoteServer server) {
        this.checkWorking();
        this.server = server;
    }

    private void collectInfo() throws MinecraftException {
        String[] rs;
        this.checkStep(MinecraftLauncherStep.NONE, MinecraftLauncherStep.COLLECTING);
        this.log("Collecting info...");
        for (MinecraftListener minecraftListener : this.listeners) {
            minecraftListener.onMinecraftPrepare();
        }
        for (MinecraftExtendedListener minecraftExtendedListener : this.extListeners) {
            minecraftExtendedListener.onMinecraftCollecting();
        }
        this.log("Force update:", this.forceUpdate);
        this.versionName = this.settings.get("login.version.game");
        if (this.versionName == null || this.versionName.isEmpty()) {
            throw new IllegalArgumentException("Version name is NULL or empty!");
        }
        this.log("Selected version:", this.versionName);
        this.account = this.pm.getSelectedAccount();
        if (Objects.isNull(this.account) || this.account.getUsername().isEmpty()) {
            throw new IllegalArgumentException("login is NULL or empty!");
        }
        this.log("Selected account:", this.account.toDebugString());
        this.versionSync = this.vm.getVersionSyncInfo(this.versionName);
        if (this.versionSync == null) {
            throw new IllegalArgumentException("Cannot find version " + this.version);
        }
        this.log("Version sync info:", this.versionSync);
        try {
            if (this.versionSync.getLocal() != null && ((CompleteVersion)this.versionSync.getLocal()).getDownloads() == null && this.versionSync.getRemote() != null) {
                this.versionSync.setLocal(null);
            }
            this.deJureVersion = this.versionSync.resolveCompleteVersion(this.vm, this.forceUpdate);
        }
        catch (IOException e2) {
            Alert.showMessage(Localizable.get("version.manager.resolve.title"), Localizable.get("version.manager.resolve.message"));
            throw new MinecraftLauncherAborted(e2);
        }
        if (this.deJureVersion == null) {
            throw new NullPointerException("Complete version is NULL");
        }
        this.version = this.deJureVersion;
        this.gameDir = new File(this.settings.get("minecraft.gamedir"));
        try {
            FileUtil.createFolder(this.gameDir);
        }
        catch (IOException e3) {
            throw new MinecraftException("Cannot createScrollWrapper working directory!", "folder-not-found", e3);
        }
        this.runningMinecraftDir = this.version.isModpack() ? ModpackUtil.getPathByVersion(this.version).toFile() : this.gameDir;
        File serverResourcePacks = new File(this.runningMinecraftDir, "server-resource-packs");
        try {
            FileUtil.createFolder(serverResourcePacks);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Can't create " + serverResourcePacks, iOException);
        }
        File file = new File(this.runningMinecraftDir, "mods");
        try {
            FileUtil.createFolder(file);
        }
        catch (IOException e5) {
            throw new RuntimeException("Can't create " + file, e5);
        }
        this.globalAssetsDir = new File(this.gameDir, "assets");
        try {
            FileUtil.createFolder(this.globalAssetsDir);
        }
        catch (IOException e6) {
            throw new RuntimeException("Cannot createScrollWrapper assets directory!", e6);
        }
        this.assetsIndexesDir = new File(this.globalAssetsDir, "indexes");
        try {
            FileUtil.createFolder(this.assetsIndexesDir);
        }
        catch (IOException e7) {
            throw new RuntimeException("Cannot createScrollWrapper assets indexes directory!", e7);
        }
        this.assetsObjectsDir = new File(this.globalAssetsDir, "objects");
        try {
            FileUtil.createFolder(this.assetsObjectsDir);
        }
        catch (IOException e8) {
            throw new RuntimeException("Cannot createScrollWrapper assets objects directory!", e8);
        }
        this.nativeDir = new File(this.gameDir, "versions/" + this.version.getID() + "/natives");
        if (!OS.is(OS.WINDOWS) && this.nativeDir.getPath().chars().anyMatch(e -> Character.UnicodeBlock.of(e).equals(Character.UnicodeBlock.CYRILLIC))) {
            try {
                this.nativeDir = Files.createTempDirectory("natives", new FileAttribute[0]).toFile();
                this.nativeDir.deleteOnExit();
                this.clearNatives = true;
            }
            catch (IOException e9) {
                throw new RuntimeException("Cannot createScrollWrapper native files directory!", e9);
            }
        }
        try {
            FileUtil.createFolder(this.nativeDir);
        }
        catch (IOException e10) {
            throw new RuntimeException("Cannot createScrollWrapper native files directory!", e10);
        }
        this.programArgs = this.settings.get("minecraft.args");
        if (this.programArgs != null && this.programArgs.isEmpty()) {
            this.programArgs = null;
        }
        this.javaArgs = this.settings.get("minecraft.javaargs");
        if (this.javaArgs != null && this.javaArgs.isEmpty()) {
            this.javaArgs = null;
        }
        this.windowSize = this.settings.getClientWindowSize();
        if (this.windowSize[0] < 1) {
            throw new IllegalArgumentException("Invalid window width!");
        }
        if (this.windowSize[1] < 1) {
            throw new IllegalArgumentException("Invalid window height!");
        }
        this.fullScreen = this.settings.getBoolean("minecraft.fullscreen");
        this.ramSize = this.version.isModpack() && this.version.getModpack().isModpackMemory() ? this.version.getModpack().getMemory() : this.settings.getInteger("minecraft.memory.ram2");
        if (this.ramSize < 512) {
            throw new IllegalArgumentException("Invalid RAM size!");
        }
        for (MinecraftLauncherAssistantInterface assistant : this.assistants) {
            assistant.collectInfo(this);
        }
        this.log("Checking conditions...");
        if (!this.version.appliesToCurrentEnvironment()) {
            Alert.showLocWarning("launcher.warning.title", (Object)"launcher.warning.incompatible.environment");
        }
        if (this.version.getMinecraftArguments() == null && this.version.getArguments() == null) {
            throw new MinecraftException("Can't run version, missing minecraftArguments", "noArgs", new Object[0]);
        }
        if (this.version.getMinimumCustomLauncherVersion() > TLauncher.getInnerSettings().getInteger("tlauncher.game.version.compatible")) {
            throw new MinecraftException("Alternative launcher is incompatible with launching version!", "incompatible", new Object[0]);
        }
        String[] sh = new File(this.runningMinecraftDir, "shaderpacks").list();
        if (Objects.nonNull(sh) && sh.length > 0) {
            StringBuilder b = new StringBuilder("shaderpacks:");
            this.print(sh, b);
        }
        if (Objects.nonNull(rs = new File(this.runningMinecraftDir, "resourcepacks").list()) && rs.length > 0) {
            StringBuilder b = new StringBuilder("resourcepacks:");
            this.print(rs, b);
        }
    }

    private void print(String[] sh, StringBuilder b) {
        for (String f : sh) {
            b.append(f).append(",");
        }
        this.log(b.substring(0, b.length() - 1));
    }

    private void downloadResources() throws MinecraftException {
        VersionSyncInfoContainer versionSyncInfoContainer;
        this.checkStep(MinecraftLauncherStep.COLLECTING, MinecraftLauncherStep.DOWNLOADING);
        for (MinecraftExtendedListener minecraftExtendedListener : this.extListeners) {
            minecraftExtendedListener.onMinecraftComparingAssets();
        }
        List<AssetIndex.AssetObject> assets = this.compareAssets();
        for (MinecraftExtendedListener listener : this.extListeners) {
            listener.onMinecraftDownloading();
        }
        try {
            versionSyncInfoContainer = this.vm.downloadVersion(this.versionSync, this.settings.getBoolean("skin.status.checkbox.state"), this.forceUpdate);
        }
        catch (IOException e) {
            throw new MinecraftException("Cannot download version!", "download-jar", e);
        }
        versionSyncInfoContainer.addHandler(new DefaultDownloadableContainerHandler());
        DownloadableContainer assetsContainer = this.am.downloadResources(this.version, assets, this.forceUpdate);
        assetsContainer.addHandler(new DefaultDownloadableContainerHandler());
        DownloadableContainer modPackContainer = this.modpackManager.getContainer(this.version, this.forceUpdate);
        modPackContainer.addHandler(new DefaultDownloadableContainerHandler());
        for (MinecraftLauncherAssistantInterface assistant : this.assistants) {
            assistant.collectResources(this);
        }
        DownloadableContainer logContainer = this.logClientConfigurationComponent.getContainer(this.version, this.gameDir, this.forceUpdate);
        this.downloader.add(logContainer);
        this.downloader.add(assetsContainer);
        this.downloader.add(versionSyncInfoContainer);
        this.downloader.add(modPackContainer);
        ArrayList list = Lists.newArrayList(this.downloader.getDownloadableContainers());
        this.downloader.startDownloadAndWait();
        for (DownloadableContainer container : list) {
            if (container.isAborted()) {
                throw new MinecraftLauncherAborted(new AbortedDownloadException());
            }
            if (container.getErrors().isEmpty() || !container.isRequireAllFiles()) continue;
            String message = "download";
            if (Objects.nonNull(container.getErrors().get(0).getCause()) && container.getErrors().get(0).getCause() instanceof FileSystemException) {
                message = "delete.file";
            }
            throw new MinecraftException(" ", message, container.getErrors().get(0));
        }
        for (DownloadableContainer container : list) {
            if (container.getErrors().isEmpty() || container.isRequireAllFiles()) continue;
            Alert.showWarning(Localizable.get("version.error.message.title"), Localizable.getByKeys("version.error.message", new Object[0]), container.getErrors().get(0).getMessage() + " ->" + container.getErrors().get(0).getCause().getMessage());
        }
        try {
            this.vm.getLocalList().saveVersion(this.deJureVersion);
        }
        catch (IOException e) {
            this.log("Cannot save version!", e);
        }
    }

    private void constructProcess() throws MinecraftException {
        this.version = TLauncher.getInstance().getTLauncherManager().createUpdatedVersion(this.version, true);
        for (MinecraftExtendedListener listener : this.extListeners) {
            listener.onMinecraftReconstructingAssets();
        }
        try {
            this.localAssetsDir = this.reconstructAssets();
        }
        catch (IOException e) {
            throw new MinecraftException("Cannot recounstruct assets!", "download-jar", e);
        }
        for (MinecraftExtendedListener listener : this.extListeners) {
            listener.onMinecraftUnpackingNatives();
        }
        try {
            this.unpackNatives(this.forceUpdate);
        }
        catch (IOException e) {
            throw new MinecraftException("Cannot unpack natives!", "unpack-natives", e);
        }
        this.checkAborted();
        for (MinecraftExtendedListener listener : this.extListeners) {
            listener.onMinecraftDeletingEntries();
        }
        try {
            this.deleteEntries();
        }
        catch (IOException e) {
            throw new MinecraftException("Cannot delete entries!", "delete-entries", e);
        }
        try {
            this.deleteLibraryEntries();
        }
        catch (Exception e) {
            throw new MinecraftException("Cannot delete library entries!", "delete-entries", e);
        }
        this.checkAborted();
        this.log("Constructing process...");
        for (MinecraftExtendedListener listener : this.extListeners) {
            listener.onMinecraftConstructing();
        }
        this.launcher = new JavaProcessLauncher(this.javaDir.getAbsolutePath(), new String[0]);
        this.launcher.directory(this.runningMinecraftDir);
        if (OS.OSX.isCurrent()) {
            Object icon = null;
            try {
                icon = this.getAssetObject("icons/minecraft.icns");
            }
            catch (IOException e) {
                this.log("Cannot get icon file from assets.", e);
            }
            if (icon != null) {
                this.launcher.addCommand("-Xdock:icon=\"" + ((File)icon).getAbsolutePath() + "\"", "-Xdock:name=Minecraft");
            }
        }
        this.launcher.addCommands(this.getJVMArguments());
        if (this.javaArgs != null) {
            this.launcher.addSplitCommands(this.javaArgs);
        }
        for (MinecraftLauncherAssistantInterface assistant : this.assistants) {
            assistant.constructJavaArguments(this);
        }
        this.launcher.addCommand(this.version.getMainClass());
        this.launcher.addCommands(this.getMinecraftArguments());
        if (this.fullScreen) {
            this.launcher.addCommand("--fullscreen");
        }
        if (this.server != null) {
            String[] address = StringUtils.split((String)this.server.getAddress(), (char)':');
            address = this.checkAndReplaceWrongAddress(address);
            switch (address.length) {
                case 2: {
                    this.launcher.addCommand("--port", address[1]);
                }
                case 1: {
                    this.launcher.addCommand("--server", address[0]);
                    break;
                }
                default: {
                    this.log("Cannot recognize server:", this.server);
                }
            }
            if (this.server.getName() == null) {
                this.server = null;
            }
        }
        if (this.programArgs != null) {
            this.launcher.addSplitCommands(this.programArgs);
        }
        for (MinecraftLauncherAssistantInterface assistant : this.assistants) {
            assistant.constructProgramArguments(this);
        }
        this.log("Full command: " + this.launcher.getCommandsAsString());
    }

    private String[] checkAndReplaceWrongAddress(String[] address) {
        try {
            InetAddress.getByName(address[0]);
        }
        catch (UnknownHostException e) {
            MinecraftPing p = new MinecraftPing();
            MinecraftPingOptions options = new MinecraftPingOptions().setHostname(address[0]);
            if (address.length == 2) {
                options.setPort(Integer.parseInt(address[1]));
            }
            try {
                p.resolveDNS(options);
                return new String[]{options.getHostname(), String.valueOf(options.getPort())};
            }
            catch (Throwable e1) {
                U.log(e1);
            }
        }
        return address;
    }

    private void checkExtraConditions() {
        int res;
        String message;
        this.checkStep(MinecraftLauncherStep.DOWNLOADING, MinecraftLauncherStep.CONSTRUCTING);
        Configuration conf = TLauncher.getInstance().getConfiguration();
        boolean skinVersion = TLauncher.getInstance().getTLauncherManager().useTLauncherAccount(this.version);
        if (skinVersion && !conf.getBoolean("skin.notification.off")) {
            if (!conf.getBoolean("skin.notification.off.temp")) {
                conf.set("skin.notification.off.temp", (Object)true);
                SwingUtilities.invokeLater(SkinNotification::showMessage);
                TLauncher.getInstance().getVersionManager().startRefresh(true);
                throw new MinecraftLauncherAborted("shown skin message");
            }
            conf.set("skin.notification.off.temp", (Object)false);
        } else if (this.account.getType().equals((Object)Account.AccountType.TLAUNCHER) && !skinVersion && !conf.getBoolean("skin.not.work.notification.hide") && Alert.showWarningMessageWithCheckBox("skin.notification.title", message = String.format(Localizable.get("skin.not.work.notification"), ImageCache.getRes((String)"tlauncher-user.png").toExternalForm(), ImageCache.getRes((String)"need-tl-version-for-skins.png").toExternalForm()), 500)) {
            conf.set("skin.not.work.notification.hide", (Object)true);
        }
        if (Objects.nonNull(this.server) && this.server.isOfficialAccount() && !Account.AccountType.OFFICIAL_ACCOUNTS.contains((Object)this.account.getType()) && (res = Alert.showConfirmDialog(0, 2, "", Localizable.get("account.not.proper.warn"), null, Localizable.get("ui.go.no.matter"), Localizable.get("ui.no"))) == 1) {
            throw new MinecraftLauncherAborted("shown mojang skin message");
        }
    }

    private File reconstructAssets() throws IOException {
        String assetVersion = this.version.getAssets() == null ? "legacy" : this.version.getAssets();
        File indexFile = new File(this.assetsIndexesDir, assetVersion + ".json");
        File virtualRoot = new File(new File(this.globalAssetsDir, "virtual"), assetVersion);
        if (!indexFile.isFile()) {
            this.log("No assets index file " + virtualRoot + "; can't reconstruct assets");
            return virtualRoot;
        }
        AssetIndex index = this.gson.fromJson(FileUtil.readFile(indexFile), AssetIndex.class);
        if (index.isVirtual()) {
            this.log("Reconstructing virtual assets folder at " + virtualRoot);
            for (Map.Entry<String, AssetIndex.AssetObject> entry : index.getFileMap().entrySet()) {
                this.checkAborted();
                File target = new File(virtualRoot, entry.getKey());
                File original = new File(new File(this.assetsObjectsDir, entry.getValue().getHash().substring(0, 2)), entry.getValue().getHash());
                if (!original.isFile()) {
                    this.log("Skipped reconstructing:", original);
                    continue;
                }
                if (!this.forceUpdate && target.isFile()) continue;
                FileUtils.copyFile(original, target, false);
                this.log(original, "->", target);
            }
            FileUtil.writeFile(new File(virtualRoot, ".lastused"), this.dateAdapter.toString(new Date()));
        }
        return virtualRoot;
    }

    private File getAssetObject(String name) throws IOException {
        String assetVersion = this.version.getAssets();
        File indexFile = new File(this.assetsIndexesDir, assetVersion + ".json");
        AssetIndex index = this.gson.fromJson(FileUtil.readFile(indexFile), AssetIndex.class);
        if (index.getFileMap() == null) {
            throw new IOException("Cannot get filemap!");
        }
        if (Objects.isNull(index.getFileMap().get(name))) {
            return null;
        }
        String hash = index.getFileMap().get(name).getHash();
        return new File(this.assetsObjectsDir, hash.substring(0, 2) + "/" + hash);
    }

    private void unpackNatives(boolean force) throws IOException {
        this.log("Unpacking natives...");
        Collection<Library> libraries = this.version.getRelevantLibraries();
        OS os = OS.CURRENT;
        if (force) {
            this.nativeDir.delete();
        }
        for (Library library : libraries) {
            ZipFile zip;
            Map<OS, String> nativesPerOs = library.getNatives();
            if (nativesPerOs == null || nativesPerOs.get((Object)os) == null) continue;
            File file = new File(MinecraftUtil.getWorkingDirectory(), "libraries/" + library.getArtifactPath(nativesPerOs.get((Object)os)));
            if (!file.isFile()) {
                throw new IOException("Required archive doesn't exist: " + file.getAbsolutePath());
            }
            try {
                zip = new ZipFile(file);
            }
            catch (IOException e) {
                throw new IOException("Error opening ZIP archive: " + file.getAbsolutePath(), e);
            }
            ExtractRules extractRules = library.getExtractRules();
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                int length;
                ZipEntry entry = entries.nextElement();
                if (extractRules != null && !extractRules.shouldExtract(entry.getName())) continue;
                File targetFile = new File(this.nativeDir, entry.getName());
                if (!force && targetFile.isFile()) continue;
                if (targetFile.getParentFile() != null) {
                    targetFile.getParentFile().mkdirs();
                }
                if (entry.isDirectory()) continue;
                BufferedInputStream inputStream = new BufferedInputStream(zip.getInputStream(entry));
                byte[] buffer = new byte[2048];
                FileOutputStream outputStream = new FileOutputStream(targetFile);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
                while ((length = inputStream.read(buffer, 0, buffer.length)) != -1) {
                    bufferedOutputStream.write(buffer, 0, length);
                }
                inputStream.close();
                bufferedOutputStream.close();
            }
            zip.close();
        }
    }

    private void deleteEntries() throws IOException {
        List<String> entries = this.version.getDeleteEntries();
        if (entries == null || entries.size() == 0) {
            return;
        }
        this.log("Removing entries...");
        File file = this.version.getFile(this.gameDir);
        this.removeFrom(file, entries);
    }

    private void deleteLibraryEntries() throws IOException {
        for (Library lib : this.version.getLibraries()) {
            List<String> entries = lib.getDeleteEntriesList();
            if (entries == null || entries.isEmpty()) continue;
            this.log("Processing entries of", lib.getName());
            this.removeFrom(new File(this.gameDir, "libraries/" + lib.getArtifactPath()), entries);
        }
    }

    private String constructClassPath(CompleteVersion version) throws MinecraftException {
        this.log("Constructing classpath...");
        StringBuilder result = new StringBuilder();
        Collection<File> classPath = version.getClassPath(OS.CURRENT, this.gameDir);
        String separator = System.getProperty("path.separator");
        for (File file : classPath) {
            if (!file.isFile()) {
                throw new MinecraftException("Classpath is not found: " + file, "classpath", file);
            }
            if (result.length() > 0) {
                result.append(separator);
            }
            result.append(file.getAbsolutePath());
        }
        return result.toString();
    }

    private String[] getMinecraftArguments() {
        this.log("Getting Minecraft arguments...");
        ArrayList<String> list = new ArrayList<String>();
        List<Argument> arguments = this.version.getArguments().get((Object)ArgumentType.GAME);
        for (Argument argument : arguments) {
            if (!argument.appliesToCurrentEnvironment()) continue;
            list.addAll(Arrays.asList(argument.getValues()));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String assets = this.version.getAssets();
        map.put("auth_username", this.account.getUsername());
        map.put("auth_session", String.format("token:%s:%s", this.account.getAccessToken(), this.account.getProfile().getId()));
        if (Account.AccountType.OFFICIAL_ACCOUNTS.contains((Object)this.account.getType())) {
            map.put("auth_access_token", this.account.getAccessToken());
        } else {
            map.put("auth_access_token", "null");
        }
        map.put("user_properties", this.gson.toJson(this.account.getProperties()));
        if (this.settings.getBoolean("skip.account.property")) {
            map.put("user_properties", "{}");
        }
        map.put("auth_uuid", this.account.getUUID());
        if (Account.AccountType.MICROSOFT.equals((Object)this.account.getType())) {
            map.put("user_type", "msa");
        } else {
            map.put("user_type", "mojang");
        }
        map.put("profile_name", this.account.getProfile().getName());
        map.put("auth_player_name", this.account.getDisplayName());
        map.put("version_type", this.version.getReleaseType().toString());
        map.put("version_name", this.version.getID());
        map.put("game_directory", this.runningMinecraftDir.getAbsolutePath());
        map.put("game_assets", this.localAssetsDir.getAbsolutePath());
        map.put("assets_root", this.globalAssetsDir.getAbsolutePath());
        map.put("assets_index_name", assets == null ? "legacy" : assets);
        map.put("resolution_width", String.valueOf(this.windowSize[0]));
        map.put("resolution_height", String.valueOf(this.windowSize[1]));
        StrSubstitutor substitutor = new StrSubstitutor(map);
        String[] split = list.toArray(new String[0]);
        for (int i = 0; i < split.length; ++i) {
            split[i] = substitutor.replace(split[i]);
        }
        return split;
    }

    private String[] getJVMArguments() throws MinecraftException {
        ArrayList<String> list = new ArrayList<String>();
        HashMap<String, String> map = new HashMap<String, String>();
        if (OS.CURRENT == OS.WINDOWS && System.getProperty("os.version").startsWith("10.")) {
            list.add("-Dos.name=Windows 10");
            list.add("-Dos.version=10.0");
        }
        List<Argument> arguments = this.version.getArguments().get((Object)ArgumentType.JVM);
        for (Argument argument : arguments) {
            if (!argument.appliesToCurrentEnvironment()) continue;
            list.addAll(Arrays.asList(argument.getValues()));
        }
        list.add("-Xmx" + this.ramSize + "M");
        map.put("game_directory", this.runningMinecraftDir.getAbsolutePath());
        if (OS.Arch.TOTAL_RAM_MB < 5000 && this.getJavaVersion() == 8) {
            list.add("-XX:+UseConcMarkSweepGC");
        } else if (Objects.nonNull(this.java)) {
            list.addAll(this.java.getArgs());
        } else {
            MinecraftUtil.configureG1GC(list);
        }
        list.add("-Dminecraft.applet.TargetDirectory=${game_directory}");
        if (this.logClientConfigurationComponent.isNotNullLogClient(this.version)) {
            LogClient f = this.logClientConfigurationComponent.getLogClient(this.version);
            list.add(f.getArgument());
            map.put("path", this.logClientConfigurationComponent.buildPathLogXmlConfiguration(this.gameDir, f).toString());
        }
        if (this.version.isModpack()) {
            list.add("-DLibLoader.modsFolder=" + ModpackUtil.getPathByVersion(this.version, "mods"));
        }
        String[] split = list.toArray(new String[0]);
        map.put("natives_directory", this.nativeDir.toString());
        String classpath = this.constructClassPath(this.version);
        map.put("classpath", classpath);
        map.put("legacyClassPath", classpath);
        map.put("launcher_name", "minecraft-launcher");
        map.put("launcher_version", "2.3.173");
        map.put("classpath_separator", File.pathSeparator);
        map.put("library_directory", String.join((CharSequence)File.separator, this.gameDir.getAbsolutePath(), "libraries"));
        map.put("version_name", this.versionName);
        StrSubstitutor substitutor = new StrSubstitutor(map);
        for (int i = 0; i < split.length; ++i) {
            split[i] = substitutor.replace(split[i]);
        }
        return split;
    }

    private List<AssetIndex.AssetObject> compareAssets() {
        this.migrateOldAssets();
        this.log("Comparing assets...");
        long start = System.currentTimeMillis();
        List<AssetIndex.AssetObject> result = this.am.checkResources(this.version, !this.forceUpdate);
        this.log("finished comparing assets: " + (System.currentTimeMillis() - start) + " ms.");
        return result;
    }

    private void migrateOldAssets() {
        if (!this.globalAssetsDir.isDirectory()) {
            return;
        }
        File skinsDir = new File(this.globalAssetsDir, "skins");
        if (skinsDir.isDirectory()) {
            FileUtil.deleteDirectory(skinsDir);
        }
        IOFileFilter migratableFilter = FileFilterUtils.notFileFilter(FileFilterUtils.or(FileFilterUtils.nameFileFilter("indexes"), FileFilterUtils.nameFileFilter("log_configs"), FileFilterUtils.nameFileFilter("objects"), FileFilterUtils.nameFileFilter("virtual")));
        for (File file : new TreeSet<File>(FileUtils.listFiles(this.globalAssetsDir, TrueFileFilter.TRUE, migratableFilter))) {
            File destinationFile;
            String hash = FileUtil.getDigest(file, "SHA-1", 40);
            if (hash != null && !(destinationFile = new File(this.assetsObjectsDir, hash.substring(0, 2) + "/" + hash)).exists()) {
                this.log("Migrated old asset", file, "into", destinationFile);
                try {
                    FileUtils.copyFile(file, destinationFile);
                }
                catch (IOException e) {
                    this.log("Couldn't migrate old asset", e);
                }
            }
            FileUtils.deleteQuietly(file);
        }
        File[] assets = this.globalAssetsDir.listFiles();
        if (assets != null) {
            for (File file : assets) {
                if (file.getName().equals("indexes") || file.getName().equals("objects") || file.getName().equals("log_configs") || file.getName().equals("virtual")) continue;
                this.log("Cleaning up old assets directory", file, "after migration");
                FileUtils.deleteQuietly(file);
            }
        }
    }

    private void launchMinecraft() throws MinecraftException {
        this.checkStep(MinecraftLauncherStep.CONSTRUCTING, MinecraftLauncherStep.LAUNCHING);
        this.log("Launching Minecraft...");
        for (MinecraftListener listener : this.listeners) {
            listener.onMinecraftLaunch();
        }
        this.log("skin system is activated: " + this.getConfiguration().getBoolean("skin.status.checkbox.state"));
        this.log("Starting Minecraft " + this.versionName + "...");
        this.log("Launching in:", this.runningMinecraftDir.getAbsolutePath());
        this.startupTime = System.currentTimeMillis();
        this.console.setLauncherToKillProcess(this);
        U.gc();
        try {
            this.launcher.setListener(this);
            this.process = this.launcher.start();
            this.minecraftWorking = true;
        }
        catch (Exception e) {
            this.notifyClose();
            throw new MinecraftException("Cannot start the game!", "start", e);
        }
    }

    private void postLaunch() {
        this.checkStep(MinecraftLauncherStep.LAUNCHING, MinecraftLauncherStep.POSTLAUNCH);
        this.log("Processing post-launch actions. Assist launch:", this.assistLaunch);
        for (MinecraftExtendedListener listener : this.extListeners) {
            listener.onMinecraftPostLaunch();
        }
        if (this.assistLaunch) {
            this.waitForClose();
        } else {
            U.sleepFor(30000L);
            if (this.minecraftWorking) {
                TLauncher.kill();
            }
        }
    }

    public void killProcess() {
        if (!this.minecraftWorking) {
            throw new IllegalStateException();
        }
        this.log("Killing Minecraft forcefully");
        this.killed = true;
        this.process.stop();
    }

    public void log(Object ... o) {
        U.log("[Launcher]", o);
    }

    private void checkThread() {
        if (!Thread.currentThread().equals(this.parentThread)) {
            throw new IllegalStateException("Illegal thread!");
        }
    }

    private void checkStep(MinecraftLauncherStep prevStep, MinecraftLauncherStep currentStep) {
        this.checkAborted();
        if (prevStep == null || currentStep == null) {
            throw new NullPointerException("NULL: " + (Object)((Object)prevStep) + " " + (Object)((Object)currentStep));
        }
        if (!this.step.equals((Object)prevStep)) {
            throw new IllegalStateException("Called from illegal step: " + (Object)((Object)this.step));
        }
        this.checkThread();
        this.step = currentStep;
    }

    private void checkAborted() {
        if (!this.working) {
            throw new MinecraftLauncherAborted("Aborted at step: " + (Object)((Object)this.step));
        }
    }

    private void checkWorking() {
        if (this.working) {
            throw new IllegalStateException("Launcher is working!");
        }
    }

    @Override
    public void onJavaProcessLog(JavaProcess jp, String line) {
        if (this.firstLine) {
            this.firstLine = false;
            U.plog("===============================================================================================");
        }
        this.xmlLogDeserialization.addToLog(line);
    }

    @Override
    public void onJavaProcessEnded(JavaProcess jp) {
        Crash crash;
        this.notifyClose();
        this.console.setLauncherToKillProcess(null);
        int exit = jp.getExitCode();
        this.log("Minecraft closed with exit code: " + exit);
        this.exitCode = exit;
        Crash crash2 = crash = this.killed ? null : this.descriptor.scan();
        if (crash == null) {
            if (!this.assistLaunch) {
                TLauncher.kill();
            }
        } else {
            this.console.show(true);
            for (MinecraftListener listener : this.listeners) {
                listener.onMinecraftCrash(crash);
            }
        }
    }

    @Override
    public void onJavaProcessError(JavaProcess jp, Throwable e) {
        this.notifyClose();
        for (MinecraftListener listener : this.listeners) {
            listener.onMinecraftError(e);
        }
    }

    private synchronized void waitForClose() {
        while (this.minecraftWorking) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void notifyClose() {
        this.minecraftWorking = false;
        if (System.currentTimeMillis() - this.startupTime < 5000L) {
            U.sleepFor(1000L);
        }
        this.notifyAll();
        for (MinecraftListener listener : this.listeners) {
            listener.onMinecraftClose();
        }
        if (this.clearNatives && Files.exists(this.nativeDir.toPath(), new LinkOption[0])) {
            FileUtil.deleteDirectory(this.nativeDir);
        }
    }

    private void removeFrom(File zipFile, List<String> entries) throws IOException {
        File tempFile = File.createTempFile(zipFile.getName(), null);
        tempFile.delete();
        tempFile.deleteOnExit();
        Path moved = Files.move(zipFile.toPath(), tempFile.toPath(), new CopyOption[0]);
        if (Files.notExists(moved, new LinkOption[0])) {
            throw new IOException("Could not move the file " + zipFile.getAbsolutePath() + " -> " + tempFile.getAbsolutePath());
        }
        this.log("Removing entries from", zipFile);
        byte[] buf = new byte[1024];
        ZipInputStream zin = new ZipInputStream((InputStream)new BufferedInputStream(new FileInputStream(tempFile)), StandardCharsets.UTF_8);
        ZipOutputStream zout = new ZipOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(zipFile)), StandardCharsets.UTF_8);
        ZipEntry entry = zin.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            if (entries.contains(name)) {
                this.log("Removed:", name);
            } else {
                int len;
                zout.putNextEntry(new ZipEntry(name));
                while ((len = zin.read(buf)) > 0) {
                    zout.write(buf, 0, len);
                }
            }
            entry = zin.getNextEntry();
        }
        zin.close();
        zout.close();
        tempFile.delete();
    }

    public File getRunningMinecraftDir() {
        return this.runningMinecraftDir;
    }

    public int getJavaVersion() {
        return this.javaVersion;
    }

    public void setJavaVersion(int javaVersion) {
        this.javaVersion = javaVersion;
    }

    public MinecraftJava.CompleteMinecraftJava getJava() {
        return this.java;
    }

    public void setJava(MinecraftJava.CompleteMinecraftJava java) {
        this.java = java;
    }

    public File getJavaDir() {
        return this.javaDir;
    }

    public void setJavaDir(File javaDir) {
        this.javaDir = javaDir;
    }

    public long getStartupTime() {
        return this.startupTime;
    }

    public static class MinecraftLauncherAborted
    extends RuntimeException {
        private static final long serialVersionUID = -3001265213093607559L;

        MinecraftLauncherAborted(String message) {
            super(message);
        }

        MinecraftLauncherAborted(Throwable cause) {
            super(cause);
        }
    }

    public static enum ConsoleVisibility {
        ALWAYS,
        ON_CRASH,
        NONE;

    }

    public static enum MinecraftLauncherStep {
        NONE,
        COLLECTING,
        DOWNLOADING,
        CONSTRUCTING,
        LAUNCHING,
        POSTLAUNCH;

    }
}

