/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.minecraft.user;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.tlauncher.tlauncher.minecraft.exceptions.ParseException;
import org.tlauncher.tlauncher.minecraft.user.CodeRequestCancelledException;
import org.tlauncher.tlauncher.minecraft.user.CodeRequestErrorException;
import org.tlauncher.tlauncher.minecraft.user.MicrosoftOAuthCodeRequestException;

public class OAuthUrlParser {
    private static String findByKey(List<NameValuePair> pairs, String key) {
        Optional<NameValuePair> pair = pairs.stream().filter(p -> p.getName().equals(key)).findAny();
        return pair.map(NameValuePair::getValue).orElse(null);
    }

    public String parseAndValidate(String url) throws MicrosoftOAuthCodeRequestException, ParseException {
        List<NameValuePair> pairs;
        try {
            pairs = URLEncodedUtils.parse(new URI(url), String.valueOf(StandardCharsets.UTF_8));
        }
        catch (URISyntaxException e) {
            throw new ParseException(e);
        }
        String error = OAuthUrlParser.findByKey(pairs, "error");
        if (error != null) {
            if (error.equals("access_denied")) {
                throw new CodeRequestCancelledException("redirect page received \"access_denied\"");
            }
            throw new CodeRequestErrorException(error, OAuthUrlParser.findByKey(pairs, "error_description"));
        }
        Optional<NameValuePair> code = pairs.stream().filter(p -> p.getName().equals("code")).findAny();
        if (code.isPresent()) {
            return code.get().getValue();
        }
        throw new ParseException("no code in query");
    }
}

