/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.center;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BoxLayout;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.configuration.LangConfiguration;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.block.BlockablePanel;
import org.tlauncher.tlauncher.ui.center.CenterPanelTheme;
import org.tlauncher.tlauncher.ui.center.DefaultCenterPanelTheme;
import org.tlauncher.tlauncher.ui.center.LoadingPanelTheme;
import org.tlauncher.tlauncher.ui.center.SettingsPanelTheme;
import org.tlauncher.tlauncher.ui.center.TipPanelTheme;
import org.tlauncher.tlauncher.ui.center.UpdateTheme;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.swing.Del;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedPanel;
import org.tlauncher.tlauncher.ui.swing.extended.UnblockablePanel;
import org.tlauncher.util.U;

public class CenterPanel
extends BlockablePanel {
    private static final long serialVersionUID = -1975869198322761508L;
    public static final CenterPanelTheme defaultTheme = new DefaultCenterPanelTheme();
    public static final CenterPanelTheme tipTheme = new TipPanelTheme();
    public static final CenterPanelTheme loadingTheme = new LoadingPanelTheme();
    public static final CenterPanelTheme settingsTheme = new SettingsPanelTheme();
    public static final CenterPanelTheme updateTheme = new UpdateTheme();
    public static final Insets defaultInsets = new Insets(5, 24, 18, 24);
    public static final Insets squareInsets = new Insets(11, 15, 11, 15);
    public static final Insets ACCOUNT_LOGIN_INSETS = new Insets(11, 19, 11, 0);
    public static final Insets accountInsets = new Insets(0, 20, 1, 10);
    public static final Insets VERSION_LOGIN_INSETS = new Insets(10, 20, 10, 0);
    public static final Insets PLAY_INSETS = new Insets(11, 0, 11, 0);
    public static final Insets SERVER_SQUARE_INSETS = new Insets(1, 10, 10, 10);
    public static final Insets smallSquareInsets = new Insets(7, 7, 7, 7);
    public static final Insets smallSquareNoTopInsets = new Insets(5, 15, 5, 15);
    public static final Insets noInsets = new Insets(0, 0, 0, 0);
    public static final Insets ISETS_20 = new Insets(20, 20, 20, 20);
    public static final Insets MIDDLE_PANEL = new Insets(20, 20, 5, 20);
    protected static final int ARC_SIZE = 24;
    private final Insets insets;
    private final CenterPanelTheme theme;
    protected final ExtendedPanel messagePanel;
    protected final LocalizableLabel messageLabel;
    public final TLauncher tlauncher = TLauncher.getInstance();
    public final Configuration global = this.tlauncher.getConfiguration();
    public final LangConfiguration lang = this.tlauncher.getLang();

    public CenterPanel() {
        this(null, null);
    }

    public CenterPanel(Insets insets) {
        this(null, insets);
    }

    public CenterPanel(CenterPanelTheme theme) {
        this(theme, null);
    }

    public CenterPanel(CenterPanelTheme theme, Insets insets) {
        theme = theme == null ? defaultTheme : theme;
        this.theme = theme;
        insets = insets == null ? defaultInsets : insets;
        this.insets = insets;
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(theme.getPanelBackground());
        this.messageLabel = new LocalizableLabel("  ");
        this.messageLabel.setFont(this.getFont().deriveFont(1));
        this.messageLabel.setVerticalAlignment(0);
        this.messageLabel.setHorizontalTextPosition(0);
        this.messageLabel.setAlignmentX(0.5f);
        this.messagePanel = new ExtendedPanel();
        this.messagePanel.setLayout(new BoxLayout(this.messagePanel, 1));
        this.messagePanel.setAlignmentX(0.5f);
        this.messagePanel.setInsets(new Insets(3, 0, 3, 0));
        this.messagePanel.add((Component)this.messageLabel);
    }

    public CenterPanelTheme getTheme() {
        return this.theme;
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    protected Del del(int aligment) {
        return new Del(1, aligment, this.theme.getBorder());
    }

    protected Del del(int aligment, int width, int height) {
        return new Del(1, aligment, width, height, this.theme.getBorder());
    }

    public void defocus() {
        this.requestFocusInWindow();
    }

    public boolean setError(String message) {
        this.messageLabel.setForeground(this.theme.getFailure());
        this.messageLabel.setText(message == null || message.length() == 0 ? " " : message);
        return false;
    }

    protected boolean setMessage(String message, Object ... vars) {
        this.messageLabel.setForeground(this.theme.getFocus());
        this.messageLabel.setText(message == null || message.length() == 0 ? " " : message, vars);
        return true;
    }

    protected boolean setMessage(String message) {
        return this.setMessage(message, Localizable.EMPTY_VARS);
    }

    public static BlockablePanel sepPan(LayoutManager manager, Component ... components) {
        BlockablePanel panel = new BlockablePanel(manager){
            private static final long serialVersionUID = 1L;

            @Override
            public Insets getInsets() {
                return noInsets;
            }
        };
        panel.add(components);
        return panel;
    }

    public static BlockablePanel sepPan(Component ... components) {
        return CenterPanel.sepPan(new GridLayout(0, 1), components);
    }

    public static UnblockablePanel uSepPan(LayoutManager manager, Component ... components) {
        UnblockablePanel panel = new UnblockablePanel(manager){
            private static final long serialVersionUID = 1L;

            @Override
            public Insets getInsets() {
                return noInsets;
            }
        };
        panel.add(components);
        return panel;
    }

    public static UnblockablePanel uSepPan(Component ... components) {
        return CenterPanel.uSepPan(new GridLayout(0, 1), components);
    }

    protected void log(Object ... o) {
        U.log("[" + this.getClass().getSimpleName() + "]", o);
    }
}

