/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.scenes;

import com.sun.webkit.network.CookieManager;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.Field;
import java.net.CookieHandler;
import java.util.Map;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.SwingUtilities;
import org.tlauncher.tlauncher.handlers.ExceptionHandler;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.minecraft.auth.Authenticator;
import org.tlauncher.tlauncher.minecraft.user.oauth.OAuthApplication;
import org.tlauncher.tlauncher.ui.MainPane;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.scenes.PseudoScene;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedPanel;
import org.tlauncher.util.U;

public class MicrosoftAuthScene
extends PseudoScene {
    public static final Dimension SIZE = new Dimension(MainPane.SIZE.width, MainPane.SIZE.height);
    private final ExtendedPanel base = new ExtendedPanel();
    private WebEngine engine;
    private final MicrosoftBrowerPanel panel = new MicrosoftBrowerPanel();

    public MicrosoftAuthScene(MainPane main) {
        super(main);
        this.panel.setPreferredSize(new Dimension(MicrosoftAuthScene.SIZE.getSize().width - 250, MicrosoftAuthScene.SIZE.getSize().height - 80));
        this.base.add((Component)((Object)this.panel));
        this.base.setSize(SIZE);
        this.add((Component)this.base);
    }

    @Override
    public void setShown(boolean shown) {
        if (shown) {
            Platform.runLater(() -> {
                try {
                    this.cleanCookie();
                    OAuthApplication m = OAuthApplication.TLAUNCHER_PARAMETERS;
                    String url = String.format("%s?client_id=%s&response_type=code&redirect_uri=%s&scope=%s", m.getBasicURL(), m.getClientId(), m.getRedirectURL(), m.getScope());
                    this.engine.load(url);
                }
                catch (Throwable e) {
                    U.log(e);
                }
            });
        }
        super.setShown(shown);
    }

    private void cleanCookie() throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        CookieManager cookieManager = (CookieManager)CookieHandler.getDefault();
        Field f = cookieManager.getClass().getDeclaredField("store");
        f.setAccessible(true);
        Object cookieStore = f.get(cookieManager);
        Field bucketsField = Class.forName("com.sun.webkit.network.CookieStore").getDeclaredField("buckets");
        bucketsField.setAccessible(true);
        Map buckets = (Map)bucketsField.get(cookieStore);
        f.setAccessible(true);
        buckets.clear();
    }

    private class MicrosoftBrowerPanel
    extends JFXPanel {
        public MicrosoftBrowerPanel() {
            Platform.runLater(() -> {
                Thread.currentThread().setUncaughtExceptionHandler(ExceptionHandler.getInstance());
                Group group = new Group();
                Scene scene = new Scene((Parent)group);
                this.setScene(scene);
                WebView view = new WebView();
                view.setContextMenuEnabled(false);
                MicrosoftAuthScene.this.engine = view.getEngine();
                MicrosoftAuthScene.this.engine.setOnAlert(event -> Alert.showMessage(MicrosoftAuthScene.this.engine.getTitle(), (String)event.getData()));
                group.getChildren().add((Object)view);
                view.getEngine().locationProperty().addListener((obs, oldLocation, newLocation) -> {
                    U.log("new locathion is " + newLocation);
                    SwingUtilities.invokeLater(() -> {
                        if (newLocation.startsWith(OAuthApplication.TLAUNCHER_PARAMETERS.getBackButtonURL())) {
                            MicrosoftAuthScene.this.getMainPane().accountEditor.editor.clear();
                            MicrosoftAuthScene.this.getMainPane().openAccountEditor();
                        } else if (newLocation.startsWith(OAuthApplication.TLAUNCHER_PARAMETERS.getRedirectURL())) {
                            String authCode = newLocation.substring(newLocation.indexOf("=") + 1);
                            Account ac = MicrosoftAuthScene.this.getMainPane().accountEditor.editor.get();
                            ac.setPassword(authCode);
                            ac.setUsername("********");
                            Authenticator.authenticate(ac, MicrosoftAuthScene.this.getMainPane().accountEditor.editor);
                            MicrosoftAuthScene.this.getMainPane().openAccountEditor();
                        }
                    });
                });
            });
        }
    }
}

