/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.swing;

import java.awt.Font;
import java.awt.Insets;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.StyleSheet;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableComponent;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.swing.editor.ExtendedHTMLEditorKit;
import org.tlauncher.util.OS;

public class FlexibleEditorPanel
extends JEditorPane
implements LocalizableComponent {
    public FlexibleEditorPanel(Font font, int width) {
        if (font != null) {
            this.setFont(font);
        } else {
            font = this.getFont();
        }
        StyleSheet css = new StyleSheet();
        css.importStyleSheet(this.getClass().getResource("styles.css"));
        css.addRule("body { font-family: " + font.getFamily() + ";width:" + width + "; font-size: " + font.getSize() + "pt; } " + "a { text-decoration: underline; }");
        ExtendedHTMLEditorKit html = new ExtendedHTMLEditorKit();
        html.setStyleSheet(css);
        this.getDocument().putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setEditorKit(html);
        this.setEditable(false);
        this.setOpaque(false);
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (!e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    return;
                }
                URL url = e.getURL();
                if (url == null) {
                    return;
                }
                OS.openLink(url);
            }
        });
    }

    public FlexibleEditorPanel(int width) {
        this(new LocalizableLabel().getFont(), width);
    }

    public FlexibleEditorPanel(String type, String text, int width) {
        this(width);
        this.setContentType(type);
        this.setText(Localizable.get(text));
    }

    @Override
    public void updateLocale() {
        this.setText(Localizable.get("auth.tip.tlauncher"));
    }
}

