" Vim Keymap file for Arabic using Buckwalter Transliteration
" see
" http://qamus.org/transliteration.htm
" https://en.wikipedia.org/wiki/Buckwalter_transliteration
"
" Created By:  Rafael Ketsetsides <rketsetsides@gmail.com>
" Last Update: 2025 Sep 02

let b:keymap_name = "arabic_buckwalter"

loadkeymap

A	<char-0x0627>			" ALEF
b	<char-0x0628>			" BEH
p	<char-0x0629>			" TEH MARBUTA
t	<char-0x062a>			" TEH
v	<char-0x062b>			" THEH
j	<char-0x062c>			" JEEM
H	<char-0x062d>			" HAH
x	<char-0x062e>			" KHAH
d	<char-0x062f>			" DAL
*	<char-0x0630>			" THAL
r	<char-0x0631>			" REH
z	<char-0x0632>			" ZAIN
s	<char-0x0633>			" SEEN
$	<char-0x0634>			" SHEEN
S	<char-0x0635>			" SAD
D	<char-0x0636>			" DAD
T	<char-0x0637>			" TAH
Z	<char-0x0638>			" ZAH
E	<char-0x0639>			" AIN
g	<char-0x063a>			" GHAIN
_	<char-0x0640>			" TATWEEL
f	<char-0x0641>			" FEH
q	<char-0x0642>			" QAF
k	<char-0x0643>			" KAF
l	<char-0x0644>			" LAM
m	<char-0x0645>			" MEEM
n	<char-0x0646>			" NOON
h	<char-0x0647>			" HEH
w	<char-0x0648>			" WAW
Y	<char-0x0649>			" ALEF MAKSURA
y	<char-0x064a>			" YEH
'	<char-0x0621>			" HAMZA
|	<char-0x0622>			" ALEF WITH MADDA ABOVE
>	<char-0x0623>			" ALEF WITH HAMZA ABOVE
&	<char-0x0624>			" WAW WITH HAMZA ABOVE
<	<char-0x0625>			" ALEF WITH HAMZA BELOW
}	<char-0x0626>			" YEH WITH HAMZA ABOVE
F	<char-0x064b>			" Tanween -- FATHATAN
N	<char-0x064c>			" Tanween -- DAMMATAN
K	<char-0x064d>			" Tanween -- KASRATAN
a	<char-0x064e>			" Tanween -- FATHA
u	<char-0x064f>			" Tanween -- DAMMA
i	<char-0x0650>			" Tanween -- KASRA
~	<char-0x0651>			" Tanween -- SHADDA
o	<char-0x0652>			" Tanween -- SUKUN
;	<char-0x061b>			" Arabic Semicolon
,	<char-0x060c>			" Arabic Comma
?	<char-0x061f>			" Arabic Question Mark
{	<char-0x0671>			" ALEF WASLA
P	<char-0x067E>			" PEH
J	<char-0x0686>			" TCHEH
V	<char-0x06A4>			" VEH
G	<char-0x06AF>			" GAF
0	<char-0x06F0>			" Arabic-Indic 0
1	<char-0x06F1>			" Arabic-Indic 1
2	<char-0x06F2>			" Arabic-Indic 2
3	<char-0x06F3>			" Arabic-Indic 3
4	<char-0x06F4>			" Arabic-Indic 4
5	<char-0x06F5>			" Arabic-Indic 5
6	<char-0x06F6>			" Arabic-Indic 6
7	<char-0x06F7>			" Arabic-Indic 7
8	<char-0x06F8>			" Arabic-Indic 8
9	<char-0x06F9>			" Arabic-Indic 9
